/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.SdsSslContextProvider;
import io.grpc.xds.internal.sds.trust.SdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SdsSecretConfig;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executor;
import javax.net.ssl.TrustManagerFactory;

final class SdsClientSslContextProvider
extends SdsSslContextProvider {
    private SdsClientSslContextProvider(Node node, SdsSecretConfig certSdsConfig, SdsSecretConfig validationContextSdsConfig, CertificateValidationContext staticCertValidationContext, Executor watcherExecutor, Executor channelExecutor, EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
        super(node, certSdsConfig, validationContextSdsConfig, staticCertValidationContext, watcherExecutor, channelExecutor, upstreamTlsContext);
    }

    static SdsClientSslContextProvider getProvider(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext, Node node, Executor watcherExecutor, Executor channelExecutor) {
        Preconditions.checkNotNull((Object)upstreamTlsContext, (Object)"upstreamTlsContext");
        CommonTlsContext commonTlsContext = upstreamTlsContext.getCommonTlsContext();
        SdsSecretConfig validationContextSdsConfig = null;
        CertificateValidationContext staticCertValidationContext = null;
        if (commonTlsContext.hasCombinedValidationContext()) {
            CommonTlsContext.CombinedCertificateValidationContext combinedValidationContext = commonTlsContext.getCombinedValidationContext();
            if (combinedValidationContext.hasValidationContextSdsSecretConfig()) {
                validationContextSdsConfig = combinedValidationContext.getValidationContextSdsSecretConfig();
            }
            if (combinedValidationContext.hasDefaultValidationContext()) {
                staticCertValidationContext = combinedValidationContext.getDefaultValidationContext();
            }
        } else if (commonTlsContext.hasValidationContextSdsSecretConfig()) {
            validationContextSdsConfig = commonTlsContext.getValidationContextSdsSecretConfig();
        } else if (commonTlsContext.hasValidationContext()) {
            staticCertValidationContext = commonTlsContext.getValidationContext();
        }
        SdsSecretConfig certSdsConfig = null;
        if (commonTlsContext.getTlsCertificateSdsSecretConfigsCount() > 0) {
            certSdsConfig = commonTlsContext.getTlsCertificateSdsSecretConfigs(0);
        }
        return new SdsClientSslContextProvider(node, certSdsConfig, validationContextSdsConfig, staticCertValidationContext, watcherExecutor, channelExecutor, upstreamTlsContext);
    }

    @Override
    protected final SslContextBuilder getSslContextBuilder(CertificateValidationContext localCertValidationContext) throws CertificateException, IOException, CertStoreException {
        SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient().trustManager((TrustManagerFactory)((Object)new SdsTrustManagerFactory(localCertValidationContext)));
        if (this.tlsCertificate != null) {
            sslContextBuilder.keyManager(this.tlsCertificate.getCertificateChain().getInlineBytes().newInput(), this.tlsCertificate.getPrivateKey().getInlineBytes().newInput(), this.tlsCertificate.hasPassword() ? this.tlsCertificate.getPassword().getInlineString() : null);
        }
        return sslContextBuilder;
    }
}

