/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.elasticsearch.client;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.CreateOperation;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.HttpHost;
import org.apache.shenyu.plugin.logging.common.client.LogConsumeClient;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchLogCollectClient
implements LogConsumeClient {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchLogCollectClient.class);
    private RestClient restClient;
    private ElasticsearchTransport transport;
    private ElasticsearchClient client;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public void initClient(Properties props) {
        this.restClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(props.getProperty("Host"), Integer.parseInt(props.getProperty("port")))}).build();
        this.transport = new RestClientTransport(this.restClient, (JsonpMapper)new JacksonJsonpMapper());
        this.client = new ElasticsearchClient(this.transport);
        LOG.info("init ElasticSearchLogCollectClient success");
        if (!this.existsIndex("shenyu-access-logging")) {
            this.createIndex("shenyu-access-logging");
            LOG.info("create index success");
        }
        this.isStarted.set(true);
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    public void consume(List<ShenyuRequestLog> logs) {
        if (CollectionUtils.isEmpty(logs) || !this.isStarted.get()) {
            return;
        }
        ArrayList bulkOperations = new ArrayList();
        logs.forEach(log -> {
            try {
                bulkOperations.add(new BulkOperation.Builder().create(d -> (CreateOperation.Builder)d.document(log).index("shenyu-access-logging")).build());
            }
            catch (Exception e) {
                LOG.error("add logs error", (Throwable)e);
            }
        });
        try {
            this.client.bulk(e -> e.index("shenyu-access-logging").operations(bulkOperations));
        }
        catch (Exception e2) {
            LOG.error("elasticsearch store logs error", (Throwable)e2);
        }
    }

    public boolean existsIndex(String indexName) {
        try {
            BooleanResponse existsResponse = this.client.indices().exists(c -> c.index(indexName, new String[0]));
            return existsResponse.value();
        }
        catch (Exception e) {
            LOG.error("fail to check the index exists");
            return true;
        }
    }

    public void createIndex(String indexName) {
        try {
            this.client.indices().create(c -> c.index(indexName));
        }
        catch (IOException e) {
            LOG.error("create index error");
        }
    }

    public void close() {
        if (Objects.nonNull(this.restClient) && this.isStarted.get()) {
            try {
                this.transport.close();
            }
            catch (IOException e) {
                LOG.error("transport close has IOException : ", (Throwable)e);
            }
            try {
                this.restClient.close();
            }
            catch (IOException e) {
                LOG.error("restClient close has IOException : ", (Throwable)e);
            }
            this.isStarted.set(false);
        }
    }
}

