/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.aliyun.sls.handler;

import java.util.Objects;
import java.util.Properties;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.convert.plugin.MotanRegisterConfig;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.aliyun.sls.client.AliyunSlsLogCollectClient;
import org.apache.shenyu.plugin.aliyun.sls.collector.AliyunSlsLogCollector;
import org.apache.shenyu.plugin.aliyun.sls.config.AliyunLogCollectConfig;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingAliyunSlsPluginDataHandler
implements PluginDataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingAliyunSlsPluginDataHandler.class);
    private static final AliyunSlsLogCollectClient ALIYUN_SLS_LOG_COLLECT_CLIENT = new AliyunSlsLogCollectClient();

    public void handlerPlugin(PluginData pluginData) {
        LOG.info("AliYun sls plugin data: {}", (Object)GsonUtils.getGson().toJson((Object)pluginData));
        if (Objects.nonNull(pluginData) && Boolean.TRUE.equals(pluginData.getEnabled())) {
            AliyunLogCollectConfig.AliyunSlsLogConfig globalLogConfig = (AliyunLogCollectConfig.AliyunSlsLogConfig)((Object)GsonUtils.getInstance().fromJson(pluginData.getConfig(), AliyunLogCollectConfig.AliyunSlsLogConfig.class));
            AliyunLogCollectConfig.AliyunSlsLogConfig exist = (AliyunLogCollectConfig.AliyunSlsLogConfig)((Object)Singleton.INST.get(AliyunLogCollectConfig.AliyunSlsLogConfig.class));
            if (Objects.isNull((Object)globalLogConfig)) {
                return;
            }
            if (Objects.isNull((Object)exist) || !((Object)((Object)globalLogConfig)).equals((Object)exist)) {
                AliyunLogCollectConfig.INSTANCE.setAliyunSlsLogConfig(globalLogConfig);
                Properties properties = new Properties();
                properties.setProperty("AccessId", globalLogConfig.getAccessId().trim());
                properties.setProperty("AccessKey", globalLogConfig.getAccessKey().trim());
                properties.setProperty("Host", globalLogConfig.getHost().trim());
                properties.setProperty("ProjectName", globalLogConfig.getProjectName().trim());
                properties.setProperty("LogStore", globalLogConfig.getLogStoreName().trim());
                properties.setProperty("TtlInDay", String.valueOf(globalLogConfig.getTtlInDay()));
                properties.setProperty("ShardCount", String.valueOf(globalLogConfig.getShardCount()));
                properties.setProperty("Topic", globalLogConfig.getTopic().trim());
                properties.setProperty("sendThreadCount", String.valueOf(globalLogConfig.getSendThreadCount()));
                properties.setProperty("ioThreadCount", String.valueOf(globalLogConfig.getIoThreadCount()));
                ALIYUN_SLS_LOG_COLLECT_CLIENT.initClient(properties);
                AliyunSlsLogCollector.getInstance().start();
            }
            Singleton.INST.single(MotanRegisterConfig.class, (Object)globalLogConfig);
        } else {
            try {
                AliyunSlsLogCollector.getInstance().close();
            }
            catch (Exception e) {
                LOG.error("close log collector error", (Throwable)e);
            }
        }
    }

    public String pluginNamed() {
        return PluginEnum.LOGGING_ALIYUN_SLS.getName();
    }

    public static AliyunSlsLogCollectClient getAliyunSlsLogCollectClient() {
        return ALIYUN_SLS_LOG_COLLECT_CLIENT;
    }
}

