/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.aliyun.sls.client;

import com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.aliyun.openservices.aliyun.log.producer.Producer;
import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.aliyun.openservices.aliyun.log.producer.Result;
import com.aliyun.openservices.aliyun.log.producer.errors.LogSizeTooLargeException;
import com.aliyun.openservices.aliyun.log.producer.errors.MaxBatchCountExceedException;
import com.aliyun.openservices.aliyun.log.producer.errors.ProducerException;
import com.aliyun.openservices.aliyun.log.producer.errors.ResultFailedException;
import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.common.LogStore;
import com.aliyun.openservices.log.exception.LogException;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.logging.common.client.LogConsumeClient;
import org.apache.shenyu.plugin.logging.common.constant.GenericLoggingConstant;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunSlsLogCollectClient
implements LogConsumeClient {
    private static final Logger LOG = LoggerFactory.getLogger(AliyunSlsLogCollectClient.class);
    private Client client;
    private String projectName;
    private String logStore;
    private String topic;
    private Producer producer;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private ThreadPoolExecutor threadExecutor;

    public void initClient(Properties props) {
        if (MapUtils.isEmpty((Map)props)) {
            LOG.error("aliyun sls props is empty. failed init aliyun sls producer");
            return;
        }
        if (this.isStarted.get()) {
            this.close();
        }
        String accessId = props.getProperty("AccessId");
        String accessKey = props.getProperty("AccessKey");
        String host = props.getProperty("Host");
        if (StringUtils.isBlank((CharSequence)accessId) || StringUtils.isBlank((CharSequence)accessKey) || StringUtils.isBlank((CharSequence)host)) {
            LOG.error("init aliyun sls client error, please check accessId, accessKey or host");
            return;
        }
        this.client = new Client(host, accessId, accessKey);
        this.projectName = props.getProperty("ProjectName");
        this.topic = props.getProperty("Topic");
        this.logStore = props.getProperty("LogStore");
        int ttlInDay = Integer.parseInt(props.getProperty("TtlInDay"));
        int shardCount = Integer.parseInt(props.getProperty("ShardCount"));
        ProjectConfig projectConfig = new ProjectConfig(this.projectName, host, accessId, accessKey);
        this.producer = AliyunSlsLogCollectClient.createProducer(props, projectConfig);
        LogStore store = new LogStore(this.logStore, ttlInDay, shardCount);
        this.threadExecutor = AliyunSlsLogCollectClient.createThreadPoolExecutor(props);
        try {
            this.isStarted.set(true);
            Runtime.getRuntime().addShutdownHook(new Thread(this::close));
            this.client.CreateLogStore(this.projectName, store);
        }
        catch (LogException e) {
            LOG.warn("error code:{}, error message:{}", (Object)e.GetErrorCode(), (Object)e.GetErrorMessage());
        }
    }

    public void consume(List<ShenyuRequestLog> logs) {
        if (CollectionUtils.isEmpty(logs) || !this.isStarted.get()) {
            return;
        }
        logs.forEach(this::sendLog);
    }

    public void close() {
        if (Objects.nonNull(this.client) && this.isStarted.get()) {
            this.isStarted.set(false);
            this.client.shutdown();
            try {
                this.producer.close();
            }
            catch (ProducerException | InterruptedException e) {
                LOG.error("Close producer error.");
            }
        }
    }

    private void sendLog(ShenyuRequestLog log) {
        ArrayList<LogItem> logGroup = new ArrayList<LogItem>();
        LogItem logItem = new LogItem((int)(System.currentTimeMillis() / 1000L));
        logItem.PushBack("level", "info");
        logItem.PushBack("name", log.getRequestUri());
        logItem.PushBack("message", GsonUtils.getGson().toJson((Object)log));
        logGroup.add(logItem);
        try {
            ListenableFuture f = this.producer.send(this.projectName, this.logStore, this.topic, "shenyu-gateway", logGroup);
            Futures.addCallback((ListenableFuture)f, (FutureCallback)new ProducerFutureCallback(this.projectName, this.logStore), (Executor)this.threadExecutor);
        }
        catch (InterruptedException e) {
            LOG.warn("The current thread has been interrupted during send logs.");
        }
        catch (Exception e) {
            if (e instanceof MaxBatchCountExceedException) {
                LOG.error("The logs exceeds the maximum batch count, e={}", (Object)e.getMessage());
            }
            if (e instanceof LogSizeTooLargeException) {
                LOG.error("The size of log is larger than the maximum allowable size, e={}", (Object)e.getMessage());
            }
            LOG.error("Failed to send logs, e={}", (Object)e.getMessage());
        }
    }

    private static Producer createProducer(Properties props, ProjectConfig projectConfig) {
        int ioThreadCount = Integer.parseInt(props.getProperty("ioThreadCount"));
        if (ioThreadCount > GenericLoggingConstant.MAX_ALLOW_THREADS) {
            LOG.warn("io thread count number too large!");
            ioThreadCount = GenericLoggingConstant.MAX_ALLOW_THREADS;
        }
        ProducerConfig producerConfig = new ProducerConfig();
        producerConfig.setIoThreadCount(ioThreadCount);
        producerConfig.setLogFormat(ProducerConfig.LogFormat.JSON);
        LogProducer producer = new LogProducer(producerConfig);
        producer.putProjectConfig(projectConfig);
        return producer;
    }

    private static ThreadPoolExecutor createThreadPoolExecutor(Properties props) {
        int sendThreadCount = Integer.parseInt(props.getProperty("sendThreadCount"));
        if (sendThreadCount > GenericLoggingConstant.MAX_ALLOW_THREADS) {
            LOG.warn("send thread count number too large!");
            sendThreadCount = GenericLoggingConstant.MAX_ALLOW_THREADS;
        }
        return new ThreadPoolExecutor(sendThreadCount, GenericLoggingConstant.MAX_ALLOW_THREADS, 60000L, TimeUnit.MICROSECONDS, new LinkedBlockingQueue<Runnable>(GenericLoggingConstant.MAX_QUEUE_NUMBER), ShenyuThreadFactory.create((String)"shenyu-aliyun-sls", (boolean)true), new ThreadPoolExecutor.AbortPolicy());
    }

    private static final class ProducerFutureCallback
    implements FutureCallback<Result> {
        private static final Logger LOGGER = LoggerFactory.getLogger(ProducerFutureCallback.class);
        private final String project;
        private final String logStore;

        ProducerFutureCallback(String project, String logStore) {
            this.project = project;
            this.logStore = logStore;
        }

        public void onSuccess(@Nullable Result result) {
            LOGGER.info("Send logs to aliyun sls successfully.");
        }

        public void onFailure(Throwable throwable) {
            if (throwable instanceof ResultFailedException) {
                Result result = ((ResultFailedException)throwable).getResult();
                LOGGER.error("Failed to send logs, project={}, logStore={}, result={}", new Object[]{this.project, this.logStore, result});
            } else {
                LOGGER.error("Failed to send log, e={}", (Object)throwable.getMessage());
            }
        }
    }
}

