/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.server.etcd;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterPublisher;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterRepository;
import org.apache.shenyu.register.client.server.etcd.client.EtcdClient;
import org.apache.shenyu.register.client.server.etcd.client.EtcdListenHandler;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class EtcdClientServerRegisterRepository
implements ShenyuClientServerRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdClientServerRegisterRepository.class);
    private static final int CONTEXT_INDEX = 5;
    private ShenyuClientServerRegisterPublisher publisher;
    private EtcdClient client;

    public void init(ShenyuClientServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        this.client = new EtcdClient(config.getServerLists());
        this.publisher = publisher;
        this.initSubscribe();
    }

    public void close() {
        this.client.close();
    }

    private void initSubscribe() {
        RpcTypeEnum.acquireSupportMetadatas().forEach(rpcTypeEnum -> this.subscribeMetaData(rpcTypeEnum.getName()));
        RpcTypeEnum.acquireSupportURIs().forEach(rpcTypeEnum -> this.subscribeURI(rpcTypeEnum.getName()));
    }

    private void subscribeMetaData(String rpcType) {
        String rpcPath = RegisterPathConstants.buildMetaDataContextPathParent((String)rpcType);
        List<String> metadataPaths = this.client.getChildren(rpcPath);
        for (String metadataPath : metadataPaths) {
            String data = this.client.read(metadataPath);
            this.publishMetadata(data);
        }
        LOGGER.info("subscribe metadata change: {}", (Object)rpcPath);
        this.client.subscribeChildChanges(rpcPath, new EtcdListenHandler(){

            @Override
            public void updateHandler(String path, String value) {
                EtcdClientServerRegisterRepository.this.publishMetadata(EtcdClientServerRegisterRepository.this.client.read(path));
            }

            @Override
            public void deleteHandler(String path, String value) {
            }
        });
    }

    private void publishMetadata(String metadataData) {
        this.publisher.publish((Collection)Lists.newArrayList((Object[])new MetaDataRegisterDTO[]{(MetaDataRegisterDTO)GsonUtils.getInstance().fromJson(metadataData, MetaDataRegisterDTO.class)}));
    }

    private void subscribeURI(final String rpcType) {
        final String rpcPath = RegisterPathConstants.buildURIContextPathParent((String)rpcType);
        HashSet contextList = new HashSet();
        this.client.getChildren(rpcPath).forEach(dataPath -> contextList.add(this.getContext((String)dataPath)));
        contextList.forEach(context -> this.registerUriChildrenList(rpcPath, (String)context, rpcType));
        LOGGER.info("subscribe uri change: {}", (Object)rpcPath);
        this.client.subscribeChildChanges(rpcPath, new EtcdListenHandler(){

            @Override
            public void updateHandler(String path, String value) {
                EtcdClientServerRegisterRepository.this.registerUriChildrenList(rpcPath, EtcdClientServerRegisterRepository.this.getContext(path), rpcType);
            }

            @Override
            public void deleteHandler(String path, String value) {
                EtcdClientServerRegisterRepository.this.registerUriChildrenList(rpcPath, EtcdClientServerRegisterRepository.this.getContext(path), rpcType);
            }
        });
    }

    private void registerUriChildrenList(String rpcPath, String context, String rpcType) {
        String contextPath = String.join((CharSequence)"/", rpcPath, context);
        LinkedList<URIRegisterDTO> uriRegisterDTOList = new LinkedList<URIRegisterDTO>();
        this.client.getChildren(contextPath).forEach(path -> uriRegisterDTOList.add((URIRegisterDTO)GsonUtils.getInstance().fromJson(this.client.read((String)path), URIRegisterDTO.class)));
        if (CollectionUtils.isEmpty(uriRegisterDTOList)) {
            URIRegisterDTO uriRegisterDTO = URIRegisterDTO.builder().contextPath("/" + context).rpcType(rpcType).build();
            uriRegisterDTOList.add(uriRegisterDTO);
        }
        this.publishURI(uriRegisterDTOList);
    }

    private void publishURI(List<URIRegisterDTO> registerDTOList) {
        this.publisher.publish(registerDTOList);
    }

    private String getContext(String path) {
        String[] paths = path.split("/");
        return paths[path.startsWith("/") ? 5 : 4];
    }
}

