/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.ResourceDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.ResourceDO;
import org.apache.shenyu.admin.model.vo.PermissionMenuVO;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.utils.ListUtil;
import org.apache.shenyu.common.enums.AdminPluginOperateEnum;
import org.apache.shenyu.common.enums.AdminResourceEnum;
import org.apache.shenyu.common.enums.ConfigGroupEnum;

public final class ResourceUtil {
    private static final List<DataPermission> NEW_PLUGIN_DATA_PERMISSION = new ArrayList<DataPermission>();

    private ResourceUtil() {
    }

    public static ResourceDO buildPluginResource(String pluginName) {
        return ResourceDO.buildResourceDO(ResourceDTO.builder().parentId("1346775491550474240").title(pluginName).name(pluginName).url("/plug/" + pluginName).component(pluginName).resourceType(AdminResourceEnum.SECOND_MENU.getCode()).sort(0).icon("block").isLeaf(Boolean.FALSE).isRoute(0).status(1).perms("").build());
    }

    public static List<ResourceDO> buildPluginDataPermissionResource(String pluginResourceId, String pluginName) {
        return NEW_PLUGIN_DATA_PERMISSION.stream().map(p -> ResourceUtil.buildPluginButtonResource(pluginResourceId, pluginName, ((DataPermission)p).dataType, ((DataPermission)p).operate)).collect(Collectors.toList());
    }

    private static ResourceDO buildPluginButtonResource(String parentId, String pluginName, ConfigGroupEnum configGroupEnum, AdminPluginOperateEnum adminPluginOperateEnum) {
        ResourceDO resourceDO = ResourceDO.buildResourceDO(ResourceDTO.builder().parentId(parentId).name("").url("").component("").resourceType(AdminResourceEnum.THREE_MENU.getCode()).isLeaf(Boolean.TRUE).status(1).sort(0).icon("").isRoute(0).build());
        switch (configGroupEnum) {
            case SELECTOR: {
                resourceDO.setTitle("SHENYU.BUTTON.PLUGIN." + ConfigGroupEnum.SELECTOR.name() + "." + adminPluginOperateEnum.name());
                resourceDO.setPerms("plugin:" + pluginName + "Selector:" + adminPluginOperateEnum.getName());
                break;
            }
            case RULE: {
                resourceDO.setTitle("SHENYU.BUTTON.PLUGIN." + ConfigGroupEnum.RULE.name() + "." + adminPluginOperateEnum.name());
                resourceDO.setPerms("plugin:" + pluginName + "Rule:" + adminPluginOperateEnum.getName());
                break;
            }
            case PLUGIN: {
                resourceDO.setTitle("SHENYU.BUTTON.PLUGIN." + adminPluginOperateEnum.name());
                resourceDO.setPerms("plugin:" + pluginName + ":" + adminPluginOperateEnum.getName());
                break;
            }
        }
        return resourceDO;
    }

    public static List<PermissionMenuVO.MenuInfo> buildMenu(List<ResourceVO> metaList) {
        ArrayList<PermissionMenuVO.MenuInfo> retList = new ArrayList<PermissionMenuVO.MenuInfo>();
        if (CollectionUtils.isEmpty(metaList)) {
            return retList;
        }
        Map menuInfoMap = metaList.stream().map(PermissionMenuVO.MenuInfo::buildMenuInfo).filter(menuInfo -> Objects.nonNull(menuInfo) && StringUtils.isNotEmpty((CharSequence)menuInfo.getId())).collect(Collectors.toMap(PermissionMenuVO.MenuInfo::getId, Function.identity(), (value1, value2) -> value1));
        metaList.stream().filter(meta -> Objects.nonNull(meta) && StringUtils.isNotEmpty((CharSequence)meta.getId())).collect(Collectors.toMap(ResourceVO::getParentId, ResourceUtil::convertIds, ListUtil::mergeSet)).forEach((parent, children) -> {
            PermissionMenuVO.MenuInfo menuInfo = (PermissionMenuVO.MenuInfo)menuInfoMap.get(parent);
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                List<PermissionMenuVO.MenuInfo> targetList = Objects.isNull(menuInfo) ? retList : menuInfo.getChildren();
                children.forEach(child -> {
                    PermissionMenuVO.MenuInfo data = (PermissionMenuVO.MenuInfo)menuInfoMap.get(child);
                    if (Objects.nonNull(data)) {
                        targetList.add(data);
                    }
                });
            }
        });
        return retList;
    }

    public static List<ResourceDO> getDeleteResourceIds(List<String> resourceIds, List<ResourceDO> allMetaDataResources) {
        if (CollectionUtils.isEmpty(allMetaDataResources) || CollectionUtils.isEmpty(resourceIds)) {
            return Collections.emptyList();
        }
        ArrayList<ResourceDO> deleteResourceIds = new ArrayList<ResourceDO>();
        Map<String, ResourceDO> metaMap = ListUtil.toMap(allMetaDataResources, BaseDO::getId);
        Map<String, Set<String>> metaChildrenMap = ResourceUtil.dealChildrenMap(allMetaDataResources);
        ArrayDeque<String> cacheDatas = new ArrayDeque<String>(resourceIds);
        while (!cacheDatas.isEmpty()) {
            String resourceId = (String)cacheDatas.pollFirst();
            ResourceDO resourceVO = metaMap.get(resourceId);
            Set<String> children = metaChildrenMap.get(resourceId);
            if (Objects.nonNull(resourceVO)) {
                deleteResourceIds.add(resourceVO);
                metaMap.remove(resourceId);
            }
            if (!CollectionUtils.isNotEmpty(children)) continue;
            children.forEach(cacheDatas::addFirst);
            metaChildrenMap.remove(resourceId);
        }
        return deleteResourceIds;
    }

    private static Map<String, Set<String>> dealChildrenMap(List<ResourceDO> metaList) {
        return metaList.stream().filter(meta -> Objects.nonNull(meta) && StringUtils.isNotEmpty((CharSequence)meta.getId())).collect(Collectors.toMap(ResourceDO::getParentId, ResourceUtil::convertIds, ListUtil::mergeSet));
    }

    private static Set<String> convertIds(ResourceDO resourceDO) {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(resourceDO.getId());
        return idSet;
    }

    private static Set<String> convertIds(ResourceVO resourceVO) {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(resourceVO.getId());
        return idSet;
    }

    static {
        NEW_PLUGIN_DATA_PERMISSION.add(new DataPermission(ConfigGroupEnum.SELECTOR, AdminPluginOperateEnum.ADD));
        NEW_PLUGIN_DATA_PERMISSION.add(new DataPermission(ConfigGroupEnum.SELECTOR, AdminPluginOperateEnum.DELETE));
        NEW_PLUGIN_DATA_PERMISSION.add(new DataPermission(ConfigGroupEnum.SELECTOR, AdminPluginOperateEnum.EDIT));
        NEW_PLUGIN_DATA_PERMISSION.add(new DataPermission(ConfigGroupEnum.SELECTOR, AdminPluginOperateEnum.QUERY));
        NEW_PLUGIN_DATA_PERMISSION.add(new DataPermission(ConfigGroupEnum.RULE, AdminPluginOperateEnum.ADD));
        NEW_PLUGIN_DATA_PERMISSION.add(new DataPermission(ConfigGroupEnum.RULE, AdminPluginOperateEnum.DELETE));
        NEW_PLUGIN_DATA_PERMISSION.add(new DataPermission(ConfigGroupEnum.RULE, AdminPluginOperateEnum.EDIT));
        NEW_PLUGIN_DATA_PERMISSION.add(new DataPermission(ConfigGroupEnum.RULE, AdminPluginOperateEnum.QUERY));
        NEW_PLUGIN_DATA_PERMISSION.add(new DataPermission(ConfigGroupEnum.PLUGIN, AdminPluginOperateEnum.SYNCHRONIZE));
    }

    public static class DataPermission {
        private final ConfigGroupEnum dataType;
        private final AdminPluginOperateEnum operate;

        public DataPermission(ConfigGroupEnum dataType, AdminPluginOperateEnum operate) {
            this.dataType = dataType;
            this.operate = operate;
        }
    }
}

