/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.publish;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.event.selector.BatchSelectorDeletedEvent;
import org.apache.shenyu.admin.model.event.selector.SelectorChangedEvent;
import org.apache.shenyu.admin.model.event.selector.SelectorCreatedEvent;
import org.apache.shenyu.admin.model.event.selector.SelectorUpdatedEvent;
import org.apache.shenyu.admin.service.impl.UpstreamCheckService;
import org.apache.shenyu.admin.service.publish.AdminDataModelChangedEventPublisher;
import org.apache.shenyu.admin.utils.ListUtil;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class SelectorEventPublisher
implements AdminDataModelChangedEventPublisher<SelectorDO> {
    private final ApplicationEventPublisher publisher;

    public SelectorEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public void onCreated(SelectorDO selector) {
        this.publish(new SelectorCreatedEvent(selector, SessionUtil.visitorName()));
    }

    @Override
    public void onUpdated(SelectorDO selector, SelectorDO before) {
        this.publish(new SelectorUpdatedEvent(selector, before, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(SelectorDO selector) {
        this.publish(new SelectorChangedEvent(selector, null, EventTypeEnum.SELECTOR_DELETE, SessionUtil.visitorName()));
    }

    public void onDeleted(Collection<SelectorDO> selectors, List<PluginDO> plugins) {
        this.publish(new BatchSelectorDeletedEvent(selectors, SessionUtil.visitorName(), plugins));
        Map<String, String> pluginMap = ListUtil.toMap(plugins, BaseDO::getId, PluginDO::getName);
        List selectorDataList = selectors.stream().map(selectorDO -> {
            String pluginName = (String)pluginMap.get(selectorDO.getPluginId());
            if (pluginName.equals(PluginEnum.DIVIDE.getName())) {
                UpstreamCheckService.removeByKey(selectorDO.getId());
            }
            return SelectorDO.transFrom(selectorDO, pluginName, null);
        }).collect(Collectors.toList());
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.DELETE, selectorDataList));
    }

    @Override
    public void publish(AdminDataModelChangedEvent event) {
        this.publisher.publishEvent((ApplicationEvent)event);
    }
}

