/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.publish;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.event.plugin.BatchPluginChangedEvent;
import org.apache.shenyu.admin.model.event.plugin.BatchPluginDeletedEvent;
import org.apache.shenyu.admin.model.event.plugin.PluginChangedEvent;
import org.apache.shenyu.admin.model.event.plugin.PluginCreatedEvent;
import org.apache.shenyu.admin.service.publish.AdminDataModelChangedEventPublisher;
import org.apache.shenyu.admin.transfer.PluginTransfer;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class PluginEventPublisher
implements AdminDataModelChangedEventPublisher<PluginDO> {
    private final ApplicationEventPublisher publisher;

    public PluginEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public void onCreated(PluginDO plugin) {
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.CREATE, Collections.singletonList(PluginTransfer.INSTANCE.mapToData(plugin))));
        this.publish(new PluginCreatedEvent(plugin, SessionUtil.visitorName()));
    }

    @Override
    public void onUpdated(PluginDO plugin, PluginDO before) {
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.UPDATE, Collections.singletonList(PluginTransfer.INSTANCE.mapToData(plugin))));
        this.publish(new PluginChangedEvent(plugin, before, EventTypeEnum.PLUGIN_UPDATE, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(PluginDO plugin) {
        this.publish(new PluginChangedEvent(plugin, null, EventTypeEnum.PLUGIN_DELETE, SessionUtil.visitorName()));
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.DELETE, Stream.of(plugin).map(PluginTransfer.INSTANCE::mapToData).collect(Collectors.toList())));
    }

    @Override
    public void onDeleted(Collection<PluginDO> plugins) {
        this.publish(new BatchPluginDeletedEvent(plugins, SessionUtil.visitorName()));
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.DELETE, plugins.stream().map(PluginTransfer.INSTANCE::mapToData).collect(Collectors.toList())));
    }

    public void onEnabled(Collection<PluginDO> plugins) {
        this.publish(new BatchPluginChangedEvent(plugins, null, EventTypeEnum.PLUGIN_UPDATE, SessionUtil.visitorName()));
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.UPDATE, plugins.stream().map(PluginTransfer.INSTANCE::mapToData).collect(Collectors.toList())));
    }

    @Override
    public void publish(AdminDataModelChangedEvent event) {
        this.publisher.publishEvent((ApplicationEvent)event);
    }
}

