/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.manager.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.shenyu.admin.model.bean.UpstreamInstance;
import org.apache.shenyu.admin.service.manager.DocManager;
import org.apache.shenyu.admin.service.manager.ServiceDocManager;
import org.apache.shenyu.admin.utils.HttpUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ServiceDocManagerImpl
implements ServiceDocManager {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceDocManagerImpl.class);
    private static final HttpUtils HTTP_UTILS = new HttpUtils();
    private static final Map<String, Long> CLUSTER_LASTSTARTUPTIME_MAP = new HashMap<String, Long>();
    private static final String SWAGGER_V2_PATH = "/v2/api-docs";
    @Resource
    private DocManager docManager;

    @Override
    public void pullApiDocument(Set<UpstreamInstance> currentServices) {
        currentServices.forEach(this::pullApiDocument);
    }

    @Override
    public void pullApiDocument(UpstreamInstance instance) {
        String clusterName = instance.getClusterName();
        if (!this.canPull(instance)) {
            LOG.info("api document has been pulled and cannot be pulled againl\uff0cinstance={}", (Object)JsonUtils.toJson((Object)instance));
            return;
        }
        String url = this.getSwaggerRequestUrl(instance);
        try {
            String body = HTTP_UTILS.get(url, Collections.EMPTY_MAP);
            this.docManager.addDocInfo(clusterName, body, callback -> LOG.info("load api document successful\uff0cclusterName={}, iPandPort={}", (Object)clusterName, (Object)(instance.getIp() + ":" + instance.getPort())));
            CLUSTER_LASTSTARTUPTIME_MAP.put(clusterName, instance.getStartupTime());
        }
        catch (Exception e) {
            LOG.error("add api document fail. url={} error={}", (Object)url, (Object)e);
        }
    }

    private boolean canPull(UpstreamInstance instance) {
        boolean canPull = false;
        Long cacheLastStartUpTime = CLUSTER_LASTSTARTUPTIME_MAP.get(instance.getClusterName());
        if (Objects.isNull(cacheLastStartUpTime) || instance.getStartupTime() > cacheLastStartUpTime) {
            canPull = true;
        }
        return canPull;
    }

    private String getSwaggerRequestUrl(UpstreamInstance instance) {
        return "http://" + instance.getIp() + ":" + instance.getPort() + SWAGGER_V2_PATH;
    }
}

