/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.SelectorConditionMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.event.selector.SelectorCreatedEvent;
import org.apache.shenyu.admin.model.event.selector.SelectorUpdatedEvent;
import org.apache.shenyu.admin.model.query.SelectorConditionQuery;
import org.apache.shenyu.admin.service.converter.SelectorHandleConverterFactor;
import org.apache.shenyu.admin.transfer.ConditionTransfer;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.admin.utils.SelectorUtil;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.dto.convert.selector.ZombieUpstream;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.UpstreamCheckUtils;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class UpstreamCheckService {
    private static final Logger LOG = LoggerFactory.getLogger(UpstreamCheckService.class);
    private static final Map<String, List<CommonUpstream>> UPSTREAM_MAP = Maps.newConcurrentMap();
    private static final Set<Integer> PENDING_SYNC = Sets.newConcurrentHashSet();
    private static final Set<ZombieUpstream> ZOMBIE_SET = Sets.newConcurrentHashSet();
    private static final String REGISTER_TYPE_HTTP = "http";
    private static int zombieRemovalTimes;
    private final int zombieCheckTimes;
    private final int scheduledTime;
    private final String registerType;
    private final boolean checked;
    private final SelectorMapper selectorMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final PluginMapper pluginMapper;
    private final SelectorConditionMapper selectorConditionMapper;
    private final SelectorHandleConverterFactor converterFactor;
    private ScheduledThreadPoolExecutor executor;
    private ScheduledFuture<?> scheduledFuture;

    public UpstreamCheckService(SelectorMapper selectorMapper, ApplicationEventPublisher eventPublisher, PluginMapper pluginMapper, SelectorConditionMapper selectorConditionMapper, ShenyuRegisterCenterConfig shenyuRegisterCenterConfig, SelectorHandleConverterFactor converterFactor) {
        this.selectorMapper = selectorMapper;
        this.eventPublisher = eventPublisher;
        this.pluginMapper = pluginMapper;
        this.selectorConditionMapper = selectorConditionMapper;
        this.converterFactor = converterFactor;
        Properties props = shenyuRegisterCenterConfig.getProps();
        this.checked = Boolean.parseBoolean(props.getProperty("checked", "false"));
        this.zombieCheckTimes = Integer.parseInt(props.getProperty("zombieCheckTimes", "5"));
        this.scheduledTime = Integer.parseInt(props.getProperty("scheduledTime", "10"));
        this.registerType = shenyuRegisterCenterConfig.getRegisterType();
        zombieRemovalTimes = Integer.parseInt(props.getProperty("zombieRemovalTimes", "60"));
        if (REGISTER_TYPE_HTTP.equalsIgnoreCase(this.registerType)) {
            this.setup();
        }
    }

    public void setup() {
        if (this.checked) {
            this.fetchUpstreamData();
            this.executor = new ScheduledThreadPoolExecutor(1, ShenyuThreadFactory.create((String)"scheduled-upstream-task", (boolean)false));
            this.scheduledFuture = this.executor.scheduleWithFixedDelay(this::scheduled, 10L, this.scheduledTime, TimeUnit.SECONDS);
        }
    }

    @PreDestroy
    public void close() {
        if (this.checked) {
            this.scheduledFuture.cancel(false);
            this.executor.shutdown();
        }
    }

    public static void removeByKey(String selectorId) {
        UPSTREAM_MAP.remove(selectorId);
    }

    public boolean submit(String selectorId, CommonUpstream commonUpstream) {
        if (!REGISTER_TYPE_HTTP.equalsIgnoreCase(this.registerType) || !this.checked) {
            return false;
        }
        List upstreams = UPSTREAM_MAP.computeIfAbsent(selectorId, k -> new CopyOnWriteArrayList());
        if (commonUpstream.isStatus()) {
            Optional<CommonUpstream> exists = upstreams.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getUpstreamUrl()) && item.getUpstreamUrl().equals(commonUpstream.getUpstreamUrl())).findFirst();
            if (!exists.isPresent()) {
                upstreams.add(commonUpstream);
            } else {
                LOG.info("upstream host {} is exists.", (Object)commonUpstream.getUpstreamHost());
            }
            PENDING_SYNC.add(commonUpstream.hashCode());
        } else {
            upstreams.removeIf(item -> item.equals((Object)commonUpstream));
            PENDING_SYNC.add(NumberUtils.INTEGER_ZERO);
        }
        this.executor.execute(() -> this.updateHandler(selectorId, upstreams, upstreams));
        return true;
    }

    public boolean checkAndSubmit(String selectorId, CommonUpstream commonUpstream) {
        boolean pass = UpstreamCheckUtils.checkUrl((String)commonUpstream.getUpstreamUrl());
        if (pass) {
            return this.submit(selectorId, commonUpstream);
        }
        ZOMBIE_SET.add(ZombieUpstream.transform((CommonUpstream)commonUpstream, (int)this.zombieCheckTimes, (String)selectorId));
        LOG.error("add zombie node, url={}", (Object)commonUpstream.getUpstreamUrl());
        return true;
    }

    public void replace(String selectorId, List<CommonUpstream> commonUpstreams) {
        if (!REGISTER_TYPE_HTTP.equalsIgnoreCase(this.registerType)) {
            return;
        }
        UPSTREAM_MAP.put(selectorId, commonUpstreams);
    }

    private void scheduled() {
        try {
            if (ZOMBIE_SET.size() > 0) {
                ZOMBIE_SET.parallelStream().forEach(this::checkZombie);
            }
            if (UPSTREAM_MAP.size() > 0) {
                UPSTREAM_MAP.forEach(this::check);
            }
        }
        catch (Exception e) {
            LOG.error("upstream scheduled check error -------- ", (Throwable)e);
        }
    }

    private void checkZombie(ZombieUpstream zombieUpstream) {
        ZOMBIE_SET.remove(zombieUpstream);
        String selectorId = zombieUpstream.getSelectorId();
        CommonUpstream commonUpstream = zombieUpstream.getCommonUpstream();
        boolean pass = UpstreamCheckUtils.checkUrl((String)commonUpstream.getUpstreamUrl());
        if (pass) {
            commonUpstream.setTimestamp(System.currentTimeMillis());
            commonUpstream.setStatus(true);
            LOG.info("UpstreamCacheManager check zombie upstream success the url: {}, host: {} ", (Object)commonUpstream.getUpstreamUrl(), (Object)commonUpstream.getUpstreamHost());
            List old = ListUtils.unmodifiableList(UPSTREAM_MAP.getOrDefault(selectorId, Collections.emptyList()));
            this.submit(selectorId, commonUpstream);
            this.updateHandler(selectorId, old, UPSTREAM_MAP.get(selectorId));
        } else {
            LOG.error("check zombie upstream the url={} is fail", (Object)commonUpstream.getUpstreamUrl());
            if (zombieUpstream.getZombieCheckTimes() > NumberUtils.INTEGER_ZERO) {
                zombieUpstream.setZombieCheckTimes(zombieUpstream.getZombieCheckTimes() - NumberUtils.INTEGER_ONE);
                ZOMBIE_SET.add(zombieUpstream);
            }
        }
    }

    private void check(String selectorId, List<CommonUpstream> upstreamList) {
        ArrayList successList = Lists.newArrayListWithCapacity((int)upstreamList.size());
        for (CommonUpstream commonUpstream : upstreamList) {
            boolean pass = UpstreamCheckUtils.checkUrl((String)commonUpstream.getUpstreamUrl());
            if (pass) {
                if (!commonUpstream.isStatus()) {
                    commonUpstream.setTimestamp(System.currentTimeMillis());
                    commonUpstream.setStatus(true);
                    LOG.info("UpstreamCacheManager check success the url: {}, host: {} ", (Object)commonUpstream.getUpstreamUrl(), (Object)commonUpstream.getUpstreamHost());
                }
                successList.add(commonUpstream);
                continue;
            }
            commonUpstream.setStatus(false);
            ZOMBIE_SET.add(ZombieUpstream.transform((CommonUpstream)commonUpstream, (int)this.zombieCheckTimes, (String)selectorId));
            LOG.error("check the url={} is fail ", (Object)commonUpstream.getUpstreamUrl());
        }
        this.updateHandler(selectorId, upstreamList, successList);
    }

    private void updateHandler(String selectorId, List<CommonUpstream> upstreamList, List<CommonUpstream> successList) {
        if (successList.size() == upstreamList.size() && PENDING_SYNC.size() == 0) {
            return;
        }
        this.removePendingSync(successList);
        if (successList.size() > 0) {
            UPSTREAM_MAP.put(selectorId, successList);
            this.updateSelectorHandler(selectorId, successList);
        } else {
            UPSTREAM_MAP.remove(selectorId);
            this.updateSelectorHandler(selectorId, new ArrayList<CommonUpstream>());
        }
    }

    private void removePendingSync(List<CommonUpstream> successList) {
        PENDING_SYNC.removeIf(NumberUtils.INTEGER_ZERO::equals);
        successList.forEach(commonUpstream -> PENDING_SYNC.remove(commonUpstream.hashCode()));
    }

    private void updateSelectorHandler(String selectorId, List<CommonUpstream> aliveList) {
        SelectorDO selectorDO = this.selectorMapper.selectById(selectorId);
        if (Objects.isNull(selectorDO)) {
            return;
        }
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        String handler = this.converterFactor.newInstance(pluginDO.getName()).handler(selectorDO.getHandle(), aliveList);
        selectorDO.setHandle(handler);
        this.selectorMapper.updateSelective(selectorDO);
        List<ConditionData> conditionDataList = ConditionTransfer.INSTANCE.mapToSelectorDOS(this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(selectorDO.getId())));
        SelectorData selectorData = SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList);
        selectorData.setHandle(handler);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
    }

    public void fetchUpstreamData() {
        List<PluginDO> pluginDOList = this.pluginMapper.selectByNames(PluginEnum.getUpstreamNames());
        if (CollectionUtils.isEmpty(pluginDOList)) {
            return;
        }
        Map<String, String> pluginMap = pluginDOList.stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, PluginDO::getName, (value1, value2) -> value1));
        List<SelectorDO> selectorDOList = this.selectorMapper.findByPluginIds(new ArrayList<String>(pluginMap.keySet()));
        long currentTimeMillis = System.currentTimeMillis();
        Optional.ofNullable(selectorDOList).orElseGet(ArrayList::new).stream().filter(selectorDO -> Objects.nonNull(selectorDO) && StringUtils.isNotEmpty((CharSequence)selectorDO.getHandle())).forEach(selectorDO -> {
            String name = (String)pluginMap.get(selectorDO.getPluginId());
            List commonUpstreams = this.converterFactor.newInstance(name).convertUpstream(selectorDO.getHandle()).stream().filter(upstream -> upstream.isStatus() || upstream.getTimestamp() > currentTimeMillis - TimeUnit.SECONDS.toMillis(zombieRemovalTimes)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(commonUpstreams)) {
                UPSTREAM_MAP.put(selectorDO.getId(), commonUpstreams);
                PENDING_SYNC.add(NumberUtils.INTEGER_ZERO);
            }
        });
    }

    @EventListener(value={SelectorCreatedEvent.class})
    public void onSelectorCreated(SelectorCreatedEvent event) {
        PluginDO plugin = this.pluginMapper.selectById(event.getSelector().getPluginId());
        List<DivideUpstream> existDivideUpstreams = SelectorUtil.buildDivideUpstream(event.getSelector(), plugin.getName());
        if (CollectionUtils.isNotEmpty(existDivideUpstreams)) {
            this.replace(event.getSelector().getId(), CommonUpstreamUtils.convertCommonUpstreamList(existDivideUpstreams));
        }
    }

    @EventListener(value={SelectorUpdatedEvent.class})
    public void onSelectorUpdated(SelectorUpdatedEvent event) {
        PluginDO plugin = this.pluginMapper.selectById(event.getSelector().getPluginId());
        List<DivideUpstream> existDivideUpstreams = SelectorUtil.buildDivideUpstream(event.getSelector(), plugin.getName());
        if (CollectionUtils.isNotEmpty(existDivideUpstreams)) {
            this.replace(event.getSelector().getId(), CommonUpstreamUtils.convertCommonUpstreamList(existDivideUpstreams));
        }
    }

    public static int getZombieRemovalTimes() {
        return zombieRemovalTimes;
    }
}

