/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.ResourceMapper;
import org.apache.shenyu.admin.model.dto.ResourceDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.ResourceDO;
import org.apache.shenyu.admin.model.event.plugin.BatchPluginDeletedEvent;
import org.apache.shenyu.admin.model.event.plugin.PluginCreatedEvent;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.ResourceQuery;
import org.apache.shenyu.admin.model.vo.PermissionMenuVO;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.service.ResourceService;
import org.apache.shenyu.admin.service.publish.ResourceEventPublisher;
import org.apache.shenyu.admin.utils.ListUtil;
import org.apache.shenyu.admin.utils.ResourceUtil;
import org.apache.shenyu.common.enums.AdminResourceEnum;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourceServiceImpl
implements ResourceService {
    private final ResourceMapper resourceMapper;
    private final ResourceEventPublisher publisher;

    public ResourceServiceImpl(ResourceMapper resourceMapper, ResourceEventPublisher publisher) {
        this.resourceMapper = resourceMapper;
        this.publisher = publisher;
    }

    @Override
    public int createResourceBatch(List<ResourceDO> resourceDOList) {
        return this.insertResourceBatch(resourceDOList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(ResourceDTO resourceDTO) {
        return ResourceService.super.createOrUpdate(resourceDTO);
    }

    @Override
    public int create(ResourceDTO resourceDTO) {
        return this.createOne(ResourceDO.buildResourceDO(resourceDTO));
    }

    @Override
    public int update(ResourceDTO resourceDTO) {
        ResourceDO before = this.resourceMapper.selectById(resourceDTO.getId());
        ResourceDO resource = ResourceDO.buildResourceDO(resourceDTO);
        int updateCount = this.resourceMapper.updateSelective(resource);
        if (updateCount > 0) {
            this.publisher.onUpdated(resource, before);
        }
        return updateCount;
    }

    @Override
    public void createResource(ResourceDO resourceDO) {
        this.createOne(resourceDO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(List<String> ids) {
        List<ResourceDO> deleteResource = ResourceUtil.getDeleteResourceIds(ids, this.resourceMapper.selectAll());
        List<String> deleteIds = ListUtil.map(deleteResource, BaseDO::getId);
        int deleteCount = this.resourceMapper.delete(deleteIds);
        if (deleteCount > 0) {
            this.publisher.onDeleted((Collection<ResourceDO>)deleteResource);
        }
        return deleteCount;
    }

    @Override
    public ResourceVO findById(String id) {
        return ResourceVO.buildResourceVO(this.resourceMapper.selectById(id));
    }

    @Override
    public ResourceVO findByTitle(String title) {
        return ResourceVO.buildResourceVO(this.resourceMapper.selectByTitle(title));
    }

    @Override
    public List<ResourceVO> listByTitles(List<String> titles) {
        return ListUtil.map(this.resourceMapper.selectByTitles(titles), ResourceVO::buildResourceVO);
    }

    @Override
    @Pageable
    public CommonPager<ResourceVO> listByPage(ResourceQuery resourceQuery) {
        return PageResultUtils.result(resourceQuery.getPageParameter(), () -> this.resourceMapper.selectByQuery(resourceQuery).stream().map(ResourceVO::buildResourceVO).collect(Collectors.toList()));
    }

    @Override
    public List<PermissionMenuVO.MenuInfo> getMenuTree() {
        List<ResourceVO> resourceVOList = ListUtil.map(this.resourceMapper.selectAll(), ResourceVO::buildResourceVO);
        return CollectionUtils.isEmpty(resourceVOList) ? null : ResourceUtil.buildMenu(resourceVOList);
    }

    @Override
    public List<ResourceVO> findByParentId(String id) {
        return this.resourceMapper.selectByParentId(id).stream().filter(item -> item.getResourceType().equals(AdminResourceEnum.THREE_MENU.getCode())).map(ResourceVO::buildResourceVO).collect(Collectors.toList());
    }

    @EventListener(value={PluginCreatedEvent.class})
    public void onPluginCreated(PluginCreatedEvent event) {
        ResourceDO resourceDO = ResourceUtil.buildPluginResource(event.getPlugin().getName());
        this.createOne(resourceDO);
        this.insertResourceBatch(ResourceUtil.buildPluginDataPermissionResource(resourceDO.getId(), event.getPlugin().getName()));
    }

    @EventListener(value={BatchPluginDeletedEvent.class})
    public void onPluginDeleted(BatchPluginDeletedEvent event) {
        List<ResourceVO> resources = this.listByTitles(ListUtil.map((List)event.getSource(), s -> ((PluginDO)s).getName()));
        if (CollectionUtils.isNotEmpty(resources)) {
            this.delete(ListUtil.map(resources, ResourceVO::getId));
        }
    }

    private int createOne(ResourceDO resource) {
        int insertCount = this.resourceMapper.insertSelective(resource);
        if (insertCount > 0) {
            this.publisher.onCreated(resource);
        }
        return insertCount;
    }

    private int insertResourceBatch(List<ResourceDO> resourceDOList) {
        if (CollectionUtils.isEmpty(resourceDOList)) {
            return 0;
        }
        int insertCount = this.resourceMapper.insertBatch(resourceDOList);
        if (insertCount > 0) {
            this.publisher.onCreated((Collection<ResourceDO>)resourceDOList);
        }
        return insertCount;
    }
}

