/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.MetaDataMapper;
import org.apache.shenyu.admin.model.dto.MetaDataDTO;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.MetaDataQuery;
import org.apache.shenyu.admin.model.vo.MetaDataVO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.publish.MetaDataEventPublisher;
import org.apache.shenyu.admin.transfer.MetaDataTransfer;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.admin.utils.ListUtil;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class MetaDataServiceImpl
implements MetaDataService {
    private final MetaDataMapper metaDataMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final MetaDataEventPublisher publisher;

    public MetaDataServiceImpl(MetaDataMapper metaDataMapper, ApplicationEventPublisher eventPublisher, MetaDataEventPublisher publisher) {
        this.metaDataMapper = metaDataMapper;
        this.eventPublisher = eventPublisher;
        this.publisher = publisher;
    }

    @Override
    public void saveOrUpdateMetaData(MetaDataDO exist, MetaDataRegisterDTO metaDataDTO) {
        DataEventTypeEnum eventType;
        MetaDataDO metaDataDO = MetaDataTransfer.INSTANCE.mapRegisterDTOToEntity(metaDataDTO);
        if (Objects.isNull(exist)) {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            metaDataDO.setId(UUIDUtils.getInstance().generateShortUuid());
            metaDataDO.setDateCreated(currentTime);
            metaDataDO.setDateUpdated(currentTime);
            this.metaDataMapper.insert(metaDataDO);
            eventType = DataEventTypeEnum.CREATE;
        } else {
            metaDataDO.setId(exist.getId());
            this.metaDataMapper.update(metaDataDO);
            eventType = DataEventTypeEnum.UPDATE;
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, eventType, Collections.singletonList(MetaDataTransfer.INSTANCE.mapToData(metaDataDO))));
    }

    @Override
    public String createOrUpdate(MetaDataDTO metaDataDTO) {
        return StringUtils.isBlank((CharSequence)metaDataDTO.getId()) ? this.create(metaDataDTO) : this.update(metaDataDTO);
    }

    @Override
    public int delete(List<String> ids) {
        List<MetaDataDO> deletedMetaData = this.metaDataMapper.selectByIdList(ids);
        if (CollectionUtils.isEmpty(deletedMetaData)) {
            return 0;
        }
        int count = this.metaDataMapper.deleteByIdList(ids);
        if (count > 0) {
            this.publisher.onDeleted((Collection<MetaDataDO>)deletedMetaData);
        }
        return count;
    }

    @Override
    public String enabled(List<String> ids, Boolean enabled) {
        List<MetaDataDO> metaDataDoList = this.metaDataMapper.selectByIdList(ids);
        if (CollectionUtils.isEmpty(metaDataDoList)) {
            return "ID NOT EXIST!";
        }
        for (MetaDataDO metaDataDO : metaDataDoList) {
            metaDataDO.setEnabled(enabled);
        }
        if (this.metaDataMapper.updateEnableBatch(ids, enabled) > 0) {
            this.publisher.onEnabled(metaDataDoList);
        }
        return "";
    }

    @Override
    public void syncData() {
        List<MetaDataDO> all = this.metaDataMapper.findAll();
        if (CollectionUtils.isNotEmpty(all)) {
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, DataEventTypeEnum.REFRESH, MetaDataTransfer.INSTANCE.mapToDataAll(all)));
        }
    }

    @Override
    public MetaDataVO findById(String id) {
        return Optional.ofNullable(MetaDataTransfer.INSTANCE.mapToVO(this.metaDataMapper.selectById(id))).orElseGet(MetaDataVO::new);
    }

    @Override
    @Pageable
    public CommonPager<MetaDataVO> listByPage(MetaDataQuery metaDataQuery) {
        return PageResultUtils.result(metaDataQuery.getPageParameter(), () -> this.metaDataMapper.selectByQuery(metaDataQuery).stream().map(MetaDataTransfer.INSTANCE::mapToVO).collect(Collectors.toList()));
    }

    @Override
    public List<MetaDataVO> findAll() {
        return MetaDataTransfer.INSTANCE.mapToVOList(this.metaDataMapper.selectAll());
    }

    @Override
    public Map<String, List<MetaDataVO>> findAllGroup() {
        return ListUtil.groupBy(this.findAll(), MetaDataVO::getAppName);
    }

    @Override
    public List<MetaData> listAll() {
        return ListUtil.map(this.metaDataMapper.selectAll(), MetaDataTransfer.INSTANCE::mapToData);
    }

    @Override
    public MetaDataDO findByPath(String path) {
        return this.metaDataMapper.findByPath(path);
    }

    @Override
    public MetaDataDO findByServiceNameAndMethodName(String serviceName, String methodName) {
        return this.metaDataMapper.findByServiceNameAndMethod(serviceName, methodName);
    }

    @Override
    public int insert(MetaDataDO metaDataDO) {
        return this.metaDataMapper.insert(metaDataDO);
    }

    private String create(MetaDataDTO metaDataDTO) {
        Assert.isNull(this.metaDataMapper.pathExisted((Serializable)((Object)metaDataDTO.getPath())), "The path already exists and can't be added repeatedly!");
        MetaDataDO metaDataDO = MetaDataTransfer.INSTANCE.mapToEntity(metaDataDTO);
        metaDataDO.setId(UUIDUtils.getInstance().generateShortUuid());
        metaDataDO.setPathDesc(Objects.isNull(metaDataDO.getPathDesc()) ? "" : metaDataDO.getPathDesc());
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        metaDataDO.setDateCreated(currentTime);
        metaDataDO.setDateUpdated(currentTime);
        if (this.metaDataMapper.insert(metaDataDO) > 0) {
            this.publisher.onCreated(metaDataDO);
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, DataEventTypeEnum.CREATE, Collections.singletonList(MetaDataTransfer.INSTANCE.mapToData(metaDataDO))));
        return "create success";
    }

    private String update(MetaDataDTO metaDataDTO) {
        Assert.isNull(this.metaDataMapper.pathExistedExclude((Serializable)((Object)metaDataDTO.getPath()), Collections.singletonList(metaDataDTO.getId())), "The path already exists and can't be added repeatedly!");
        MetaDataDO metaDataDO = MetaDataTransfer.INSTANCE.mapToEntity(metaDataDTO);
        Optional.ofNullable(this.metaDataMapper.selectById(metaDataDTO.getId())).ifPresent(e -> metaDataDTO.setEnabled(e.getEnabled()));
        metaDataDO.setPathDesc(Objects.isNull(metaDataDO.getPathDesc()) ? "" : metaDataDO.getPathDesc());
        MetaDataDO before = this.metaDataMapper.selectById(metaDataDO.getId());
        if (this.metaDataMapper.update(metaDataDO) > 0) {
            this.publisher.onUpdated(metaDataDO, before);
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, DataEventTypeEnum.UPDATE, Collections.singletonList(MetaDataTransfer.INSTANCE.mapToData(metaDataDTO))));
        return "update success";
    }
}

