/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.converter;

import java.util.List;
import org.apache.shenyu.admin.service.converter.AbstractSelectorHandleConverter;
import org.apache.shenyu.admin.service.converter.SelectorHandleConverter;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;
import org.apache.shenyu.common.dto.convert.selector.GrpcUpstream;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.springframework.stereotype.Component;

@Component
public class GrpcSelectorHandleConverter
extends AbstractSelectorHandleConverter
implements SelectorHandleConverter {
    @Override
    public List<CommonUpstream> convertUpstream(String handle) {
        return CommonUpstreamUtils.convertCommonUpstreamList(this.convert(handle));
    }

    @Override
    public String pluginName() {
        return PluginEnum.GRPC.getName();
    }

    @Override
    protected Object doHandle(String handle, List<CommonUpstream> aliveList) {
        List<GrpcUpstream> existList = this.updateStatusAndFilter(this.convert(handle), aliveList);
        aliveList.stream().filter(alive -> !existList.stream().anyMatch(valid -> valid.getUpstreamUrl().equals(alive.getUpstreamUrl()))).forEach(alive -> existList.add(CommonUpstreamUtils.buildAliveGrpcUpstream(alive.getUpstreamUrl())));
        existList.removeIf(e -> aliveList.stream().noneMatch(alive -> alive.getUpstreamUrl().equals(e.getUpstreamUrl())));
        return existList;
    }

    private List<GrpcUpstream> convert(String handle) {
        return GsonUtils.getInstance().fromList(handle, GrpcUpstream.class);
    }
}

