/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.rule;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.RuleDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.BatchChangedEvent;
import org.apache.shenyu.admin.utils.ListUtil;

public class BatchRuleDeletedEvent
extends BatchChangedEvent {
    private final List<String> deletedIds;
    private final List<PluginDO> plugins;

    public BatchRuleDeletedEvent(Collection<RuleDO> source, String operator, List<PluginDO> plugins) {
        super(source, null, EventTypeEnum.RULE_DELETE, operator);
        this.deletedIds = ListUtil.map(source, BaseDO::getId);
        this.plugins = plugins;
    }

    @Override
    public String buildContext() {
        String selector = ((Collection)this.getSource()).stream().map(s -> ((RuleDO)s).getName()).collect(Collectors.joining(","));
        return String.format("the rule[%s] is %s", selector, StringUtils.lowerCase((String)this.getType().getType().toString()));
    }

    public List<RuleDO> getRules() {
        return ((Collection)this.getSource()).stream().map(RuleDO.class::cast).collect(Collectors.toList());
    }

    public List<PluginDO> getPlugins() {
        return this.plugins;
    }

    public List<String> getDeletedIds() {
        return this.deletedIds;
    }
}

