/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.metadata;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;

public class MetaDataChangedEvent
extends AdminDataModelChangedEvent {
    public MetaDataChangedEvent(MetaDataDO source, MetaDataDO before, EventTypeEnum type, String operator) {
        super(source, before, type, operator);
    }

    @Override
    public String buildContext() {
        MetaDataDO after = (MetaDataDO)this.getAfter();
        if (Objects.isNull(this.getBefore())) {
            return String.format("the metadata [%s %s] is %s", after.getAppName(), after.getPath(), StringUtils.lowerCase((String)this.getType().getType().toString()));
        }
        return String.format("the metadata [%s %s] is %s : %s", after.getAppName(), after.getPath(), StringUtils.lowerCase((String)this.getType().getType().toString()), this.contrast());
    }

    private String contrast() {
        MetaDataDO before = (MetaDataDO)this.getBefore();
        Objects.requireNonNull(before);
        MetaDataDO after = (MetaDataDO)this.getAfter();
        Objects.requireNonNull(after);
        if (Objects.equals(before, after)) {
            return "it no change";
        }
        StringBuilder builder = new StringBuilder();
        if (!Objects.equals(before.getAppName(), after.getAppName())) {
            builder.append(String.format("appName[%s => %s] ", before.getAppName(), after.getAppName()));
        }
        if (!Objects.equals(before.getPath(), after.getPath())) {
            builder.append(String.format("path[%s => %s] ", before.getPath(), after.getPath()));
        }
        if (!Objects.equals(before.getPathDesc(), after.getPathDesc())) {
            builder.append(String.format("path desc[%s => %s] ", before.getPathDesc(), after.getPathDesc()));
        }
        if (!Objects.equals(before.getEnabled(), after.getEnabled())) {
            builder.append(String.format("enable[%s => %s] ", before.getEnabled(), after.getEnabled()));
        }
        if (!Objects.equals(before.getServiceName(), after.getServiceName())) {
            builder.append(String.format("service[%s => %s] ", before.getServiceName(), after.getServiceName()));
        }
        if (!Objects.equals(before.getMethodName(), after.getMethodName())) {
            builder.append(String.format("method[%s => %s] ", before.getMethodName(), after.getMethodName()));
        }
        if (!Objects.equals(before.getParameterTypes(), after.getParameterTypes())) {
            builder.append(String.format("parameter type [%s => %s] ", before.getParameterTypes(), after.getParameterTypes()));
        }
        if (!Objects.equals(before.getEnabled(), after.getEnabled())) {
            builder.append(String.format("enable [%s => %s] ", before.getEnabled(), after.getEnabled()));
        }
        if (!Objects.equals(before.getRpcType(), after.getRpcType())) {
            builder.append(String.format("rpc type [%s => %s] ", before.getRpcType(), after.getRpcType()));
        }
        if (!Objects.equals(before.getRpcExt(), after.getRpcExt())) {
            builder.append(String.format("rpc ext [%s => %s] ", before.getRpcExt(), after.getRpcExt()));
        }
        return builder.toString();
    }

    @Override
    public String eventName() {
        return "meta data";
    }
}

