/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.RuleConditionDTO;
import org.apache.shenyu.admin.validation.annotation.Existed;

public final class RuleDTO
implements Serializable {
    private static final long serialVersionUID = 995629439944393704L;
    @Existed(provider=RuleMapper.class, nullOfIgnore=true, message="rule is not existed")
    private @Existed(provider=RuleMapper.class, nullOfIgnore=true, message="rule is not existed") String id;
    @NotBlank
    @Existed(provider=SelectorMapper.class, message="selector is not existed")
    private @NotBlank @Existed(provider=SelectorMapper.class, message="selector is not existed") String selectorId;
    @NotNull
    private Integer matchMode;
    @NotBlank
    private String name;
    @NotNull
    private Boolean enabled;
    @NotNull
    private Boolean loged;
    @NotNull
    private Integer sort;
    private String handle;
    @Valid
    @NotEmpty
    private @Valid @NotEmpty List<@Valid RuleConditionDTO> ruleConditions;

    public RuleDTO() {
    }

    public RuleDTO(String id, @NotBlank String selectorId, @NotNull Integer matchMode, @NotBlank String name, @NotNull Boolean enabled, Boolean loged, @NotNull Integer sort, String handle, @Valid List<RuleConditionDTO> ruleConditions) {
        this.id = id;
        this.selectorId = selectorId;
        this.matchMode = matchMode;
        this.name = name;
        this.enabled = enabled;
        this.loged = loged;
        this.sort = sort;
        this.handle = handle;
        this.ruleConditions = ruleConditions;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSelectorId() {
        return this.selectorId;
    }

    public void setSelectorId(String selectorId) {
        this.selectorId = selectorId;
    }

    public Integer getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(Integer matchMode) {
        this.matchMode = matchMode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getLoged() {
        return this.loged;
    }

    public void setLoged(Boolean loged) {
        this.loged = loged;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public List<RuleConditionDTO> getRuleConditions() {
        return this.ruleConditions;
    }

    public void setRuleConditions(List<RuleConditionDTO> ruleConditions) {
        this.ruleConditions = ruleConditions;
    }

    public static RuleDTOBuilder builder() {
        return new RuleDTOBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuleDTO)) {
            return false;
        }
        RuleDTO ruleDTO = (RuleDTO)o;
        return Objects.equals(this.id, ruleDTO.id) && Objects.equals(this.selectorId, ruleDTO.selectorId) && Objects.equals(this.matchMode, ruleDTO.matchMode) && Objects.equals(this.name, ruleDTO.name) && Objects.equals(this.enabled, ruleDTO.enabled) && Objects.equals(this.loged, ruleDTO.loged) && Objects.equals(this.sort, ruleDTO.sort) && Objects.equals(this.handle, ruleDTO.handle) && Objects.equals(this.ruleConditions, ruleDTO.ruleConditions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.selectorId, this.matchMode, this.name, this.enabled, this.loged, this.sort, this.handle, this.ruleConditions);
    }

    public static final class RuleDTOBuilder {
        private String id;
        private String selectorId;
        private Integer matchMode;
        private String name;
        private Boolean enabled;
        private Boolean loged;
        private Integer sort;
        private String handle;
        private List<RuleConditionDTO> ruleConditions;

        private RuleDTOBuilder() {
        }

        public RuleDTOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RuleDTOBuilder selectorId(String selectorId) {
            this.selectorId = selectorId;
            return this;
        }

        public RuleDTOBuilder matchMode(Integer matchMode) {
            this.matchMode = matchMode;
            return this;
        }

        public RuleDTOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RuleDTOBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public RuleDTOBuilder loged(Boolean loged) {
            this.loged = loged;
            return this;
        }

        public RuleDTOBuilder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public RuleDTOBuilder handle(String handle) {
            this.handle = handle;
            return this;
        }

        public RuleDTOBuilder ruleConditions(List<RuleConditionDTO> ruleConditions) {
            this.ruleConditions = ruleConditions;
            return this;
        }

        public RuleDTO build() {
            return new RuleDTO(this.id, this.selectorId, this.matchMode, this.name, this.enabled, this.loged, this.sort, this.handle, this.ruleConditions);
        }
    }
}

