/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.websocket;

import java.util.List;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.listener.websocket.WebsocketCollector;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.WebsocketData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;

public class WebsocketDataChangedListener
implements DataChangedListener {
    @Override
    public void onPluginChanged(List<PluginData> pluginDataList, DataEventTypeEnum eventType) {
        WebsocketData websocketData = new WebsocketData(ConfigGroupEnum.PLUGIN.name(), eventType.name(), pluginDataList);
        WebsocketCollector.send(GsonUtils.getInstance().toJson((Object)websocketData), eventType);
    }

    @Override
    public void onSelectorChanged(List<SelectorData> selectorDataList, DataEventTypeEnum eventType) {
        WebsocketData websocketData = new WebsocketData(ConfigGroupEnum.SELECTOR.name(), eventType.name(), selectorDataList);
        WebsocketCollector.send(GsonUtils.getInstance().toJson((Object)websocketData), eventType);
    }

    @Override
    public void onRuleChanged(List<RuleData> ruleDataList, DataEventTypeEnum eventType) {
        WebsocketData configData = new WebsocketData(ConfigGroupEnum.RULE.name(), eventType.name(), ruleDataList);
        WebsocketCollector.send(GsonUtils.getInstance().toJson((Object)configData), eventType);
    }

    @Override
    public void onAppAuthChanged(List<AppAuthData> appAuthDataList, DataEventTypeEnum eventType) {
        WebsocketData configData = new WebsocketData(ConfigGroupEnum.APP_AUTH.name(), eventType.name(), appAuthDataList);
        WebsocketCollector.send(GsonUtils.getInstance().toJson((Object)configData), eventType);
    }

    @Override
    public void onMetaDataChanged(List<MetaData> metaDataList, DataEventTypeEnum eventType) {
        WebsocketData configData = new WebsocketData(ConfigGroupEnum.META_DATA.name(), eventType.name(), metaDataList);
        WebsocketCollector.send(GsonUtils.getInstance().toJson((Object)configData), eventType);
    }
}

