/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.etcd;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.listener.etcd.EtcdClient;
import org.apache.shenyu.common.constant.DefaultPathConstants;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdDataDataChangedListener
implements DataChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdDataDataChangedListener.class);
    private final EtcdClient etcdClient;

    public EtcdDataDataChangedListener(EtcdClient client) {
        this.etcdClient = client;
    }

    @Override
    public void onAppAuthChanged(List<AppAuthData> changed, DataEventTypeEnum eventType) {
        for (AppAuthData data : changed) {
            String appAuthPath = DefaultPathConstants.buildAppAuthPath((String)data.getAppKey());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.etcdClient.delete(appAuthPath);
                continue;
            }
            this.updateNode(appAuthPath, data);
        }
    }

    @Override
    public void onPluginChanged(List<PluginData> changed, DataEventTypeEnum eventType) {
        for (PluginData data : changed) {
            String pluginPath = DefaultPathConstants.buildPluginPath((String)data.getName());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.etcdClient.deleteEtcdPathRecursive(pluginPath);
                String selectorParentPath = DefaultPathConstants.buildSelectorParentPath((String)data.getName());
                this.etcdClient.deleteEtcdPathRecursive(selectorParentPath);
                String ruleParentPath = DefaultPathConstants.buildRuleParentPath((String)data.getName());
                this.etcdClient.deleteEtcdPathRecursive(ruleParentPath);
                continue;
            }
            this.updateNode(pluginPath, data);
        }
    }

    @Override
    public void onSelectorChanged(List<SelectorData> changed, DataEventTypeEnum eventType) {
        if (eventType == DataEventTypeEnum.REFRESH && !changed.isEmpty()) {
            String selectorParentPath = DefaultPathConstants.buildSelectorParentPath((String)changed.get(0).getPluginName());
            this.etcdClient.deleteEtcdPathRecursive(selectorParentPath);
        }
        for (SelectorData data : changed) {
            String selectorRealPath = DefaultPathConstants.buildSelectorRealPath((String)data.getPluginName(), (String)data.getId());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.etcdClient.delete(selectorRealPath);
                continue;
            }
            this.updateNode(selectorRealPath, data);
        }
    }

    @Override
    public void onMetaDataChanged(List<MetaData> changed, DataEventTypeEnum eventType) {
        for (MetaData data : changed) {
            try {
                String metaDataPath = DefaultPathConstants.buildMetaDataPath((String)URLEncoder.encode(data.getPath(), "UTF-8"));
                if (eventType == DataEventTypeEnum.DELETE) {
                    this.etcdClient.delete(metaDataPath);
                    continue;
                }
                this.updateNode(metaDataPath, data);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("url encode error.", (Throwable)e);
                throw new ShenyuException(e.getMessage());
            }
        }
    }

    @Override
    public void onRuleChanged(List<RuleData> changed, DataEventTypeEnum eventType) {
        if (eventType == DataEventTypeEnum.REFRESH && !changed.isEmpty()) {
            String selectorParentPath = DefaultPathConstants.buildRuleParentPath((String)changed.get(0).getPluginName());
            this.etcdClient.deleteEtcdPathRecursive(selectorParentPath);
        }
        for (RuleData data : changed) {
            String ruleRealPath = DefaultPathConstants.buildRulePath((String)data.getPluginName(), (String)data.getSelectorId(), (String)data.getId());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.etcdClient.delete(ruleRealPath);
                continue;
            }
            this.updateNode(ruleRealPath, data);
        }
    }

    private void updateNode(String pluginPath, Object data) {
        this.etcdClient.put(pluginPath, GsonUtils.getInstance().toJson(data));
    }
}

