/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.aspect;

import org.apache.shenyu.admin.config.properties.DashboardProperties;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.exception.ShenyuException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PrintApiLogAspect {
    private static final Logger LOG = LoggerFactory.getLogger(PrintApiLogAspect.class);
    private final DashboardProperties properties;

    public PrintApiLogAspect(DashboardProperties properties) {
        this.properties = properties;
    }

    @Pointcut(value="@within(org.springframework.web.bind.annotation.RestController)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object logAround(ProceedingJoinPoint point) {
        long start = System.currentTimeMillis();
        try {
            this.preLog(point);
            Object object = point.proceed();
            return object;
        }
        catch (Throwable throwable) {
            throw new ShenyuException(throwable);
        }
        finally {
            this.postLog(point, start);
            SessionUtil.clean();
        }
    }

    private void postLog(ProceedingJoinPoint point, long start) {
        if (Boolean.TRUE.equals(this.properties.getEnablePrintApiLog())) {
            LOG.info("{} exec: method [{}.{}] over, time cost: {}", new Object[]{SessionUtil.visitorName(), point.getTarget().getClass().getSimpleName(), point.getSignature().getName(), System.currentTimeMillis() - start});
        }
    }

    private void preLog(ProceedingJoinPoint point) {
        if (Boolean.TRUE.equals(this.properties.getEnablePrintApiLog())) {
            LOG.info("{} exec: method [{}.{}]", new Object[]{SessionUtil.visitorName(), point.getTarget().getClass().getSimpleName(), point.getSignature().getName()});
        }
    }
}

