/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.aspect;

import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.aspect.annotation.DataPermission;
import org.apache.shenyu.admin.model.query.FilterQuery;
import org.apache.shenyu.admin.service.DataPermissionService;
import org.apache.shenyu.admin.utils.JwtUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataPermissionAspect {
    private final DataPermissionService dataPermissionService;

    public DataPermissionAspect(DataPermissionService dataPermissionService) {
        this.dataPermissionService = dataPermissionService;
    }

    @Pointcut(value="@annotation(org.apache.shenyu.admin.aspect.annotation.DataPermission)")
    public void dataPermissionCut() {
    }

    @Around(value="dataPermissionCut()")
    public Object around(ProceedingJoinPoint point) {
        try {
            return point.proceed(this.getFilterSQLData(point));
        }
        catch (Throwable throwable) {
            throw new ShenyuException(throwable);
        }
    }

    private Object[] getFilterSQLData(ProceedingJoinPoint point) {
        DataPermission dataPermission = ((MethodSignature)point.getSignature()).getMethod().getAnnotation(DataPermission.class);
        Object[] args = point.getArgs();
        if (dataPermission == null || args == null) {
            return args;
        }
        List<String> dataPermissionList = this.dataPermissionService.getDataPermission(JwtUtils.getUserInfo().getUserId());
        if (CollectionUtils.isEmpty(dataPermissionList)) {
            return args;
        }
        switch (dataPermission.dataType()) {
            case "selector": 
            case "rule": {
                Stream.of(args).filter(arg -> arg instanceof FilterQuery).forEach(q -> ((FilterQuery)q).setFilterIds(dataPermissionList));
                break;
            }
        }
        return args;
    }
}

