/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.dynatrace;

import io.micrometer.dynatrace.DynatraceApiVersion;
import io.micrometer.dynatrace.DynatraceConfig;
import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.actuate.autoconfigure.metrics.export.dynatrace.DynatraceProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.properties.StepRegistryPropertiesConfigAdapter;

class DynatracePropertiesConfigAdapter
extends StepRegistryPropertiesConfigAdapter<DynatraceProperties>
implements DynatraceConfig {
    DynatracePropertiesConfigAdapter(DynatraceProperties properties) {
        super(properties);
    }

    public String prefix() {
        return "management.metrics.export.dynatrace";
    }

    public String apiToken() {
        return this.get(DynatraceProperties::getApiToken, () -> super.apiToken());
    }

    public String deviceId() {
        return this.get(this.v1(DynatraceProperties.V1::getDeviceId), () -> super.deviceId());
    }

    public String technologyType() {
        return this.get(this.v1(DynatraceProperties.V1::getTechnologyType), () -> super.technologyType());
    }

    public String uri() {
        return this.get(DynatraceProperties::getUri, () -> super.uri());
    }

    public String group() {
        return this.get(this.v1(DynatraceProperties.V1::getGroup), () -> super.group());
    }

    public DynatraceApiVersion apiVersion() {
        return this.get(properties -> properties.getV1().getDeviceId() != null ? DynatraceApiVersion.V1 : DynatraceApiVersion.V2, () -> super.apiVersion());
    }

    public String metricKeyPrefix() {
        return this.get(this.v2(DynatraceProperties.V2::getMetricKeyPrefix), () -> super.metricKeyPrefix());
    }

    public Map<String, String> defaultDimensions() {
        return this.get(this.v2(DynatraceProperties.V2::getDefaultDimensions), () -> super.defaultDimensions());
    }

    public boolean enrichWithDynatraceMetadata() {
        return this.get(this.v2(DynatraceProperties.V2::isEnrichWithDynatraceMetadata), () -> super.enrichWithDynatraceMetadata());
    }

    private <V> Function<DynatraceProperties, V> v1(Function<DynatraceProperties.V1, V> getter) {
        return properties -> getter.apply(properties.getV1());
    }

    private <V> Function<DynatraceProperties, V> v2(Function<DynatraceProperties.V2, V> getter) {
        return properties -> getter.apply(properties.getV2());
    }
}

