/*
 * Decompiled with CFR 0.152.
 */
package reactor.tuple;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.tuple.Tuple1;
import reactor.tuple.Tuple2;
import reactor.tuple.Tuple3;
import reactor.tuple.Tuple4;
import reactor.tuple.Tuple5;
import reactor.tuple.Tuple6;
import reactor.tuple.Tuple7;
import reactor.tuple.Tuple8;
import reactor.tuple.TupleN;

public class Tuple
implements Iterable {
    protected final List<Object> entries;
    protected final int size;

    public Tuple(@Nonnull Collection<Object> values) {
        this.entries = Arrays.asList(values.toArray());
        this.size = this.entries.size();
    }

    public Tuple(Object ... values) {
        this.entries = Arrays.asList(values);
        this.size = values.length;
    }

    public static <T1> Tuple1<T1> of(T1 t1) {
        return new Tuple1(t1);
    }

    public static <T1, T2> Tuple2<T1, T2> of(T1 t1, T2 t2) {
        return new Tuple2(t1, t2);
    }

    public static <T1, T2, T3> Tuple3<T1, T2, T3> of(T1 t1, T2 t2, T3 t3) {
        return new Tuple3(t1, t2, t3);
    }

    public static <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> of(T1 t1, T2 t2, T3 t3, T4 t4) {
        return new Tuple4(t1, t2, t3, t4);
    }

    public static <T1, T2, T3, T4, T5> Tuple5<T1, T2, T3, T4, T5> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5) {
        return new Tuple5(t1, t2, t3, t4, t5);
    }

    public static <T1, T2, T3, T4, T5, T6> Tuple6<T1, T2, T3, T4, T5, T6> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6) {
        return new Tuple6(t1, t2, t3, t4, t5, t6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Tuple7<T1, T2, T3, T4, T5, T6, T7> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7) {
        return new Tuple7(t1, t2, t3, t4, t5, t6, t7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Tuple8<T1, T2, T3, T4, T5, T6, T7, T8> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8) {
        return new Tuple8(t1, t2, t3, t4, t5, t6, t7, t8);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, TRest extends Tuple> TupleN<T1, T2, T3, T4, T5, T6, T7, T8, TRest> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8, Object ... tRest) {
        return new TupleN(t1, t2, t3, t4, t5, t6, t7, t8, new Tuple(tRest));
    }

    @Nullable
    public Object get(int index) {
        return !this.entries.isEmpty() && this.size > index ? this.entries.get(index) : null;
    }

    public Object[] toArray() {
        return this.entries.toArray();
    }

    public int size() {
        return this.size;
    }

    @Nonnull
    public Iterator<?> iterator() {
        return this.entries.iterator();
    }
}

