/*
 * Decompiled with CFR 0.152.
 */
package reactor.queue;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import net.openhft.chronicle.ChronicleConfig;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.tools.ChronicleTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.function.Function;
import reactor.function.Supplier;
import reactor.io.Buffer;
import reactor.queue.QueuePersistor;
import reactor.queue.encoding.Codec;
import reactor.queue.encoding.JavaSerializationCodec;

public class IndexedChronicleQueuePersistor<T>
implements QueuePersistor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(IndexedChronicleQueuePersistor.class);
    private final Object monitor = new Object();
    private final AtomicLong lastId = new AtomicLong();
    private final AtomicLong size = new AtomicLong(0L);
    private final String basePath;
    private final Codec<T> codec;
    private final boolean deleteOnExit;
    private final IndexedChronicle data;
    private final ChronicleOfferFunction offerFun;
    private final ChronicleGetFunction getFun;
    private final ChronicleRemoveFunction removeFun;

    public IndexedChronicleQueuePersistor(@Nonnull String basePath) throws IOException {
        this(basePath, new JavaSerializationCodec(), false, true, ChronicleConfig.DEFAULT.clone());
    }

    public IndexedChronicleQueuePersistor(@Nonnull String basePath, @Nonnull Codec<T> codec, boolean clearOnStart, boolean deleteOnExit, @Nonnull ChronicleConfig config) throws IOException {
        this.basePath = basePath;
        this.codec = codec;
        this.deleteOnExit = deleteOnExit;
        if (clearOnStart) {
            for (String name : new String[]{basePath + ".data", basePath + ".index"}) {
                File file = new File(name);
                if (!file.exists()) continue;
                file.delete();
            }
        }
        ChronicleTools.warmup();
        this.data = new IndexedChronicle(basePath, config);
        this.lastId.set(this.data.findTheLastIndex());
        Excerpt ex = this.data.createExcerpt();
        while (ex.nextIndex()) {
            int len = ex.readInt();
            this.size.incrementAndGet();
            ex.skip((long)len);
        }
        this.offerFun = new ChronicleOfferFunction();
        this.getFun = new ChronicleGetFunction();
        this.removeFun = new ChronicleRemoveFunction(this.data.createTailer());
    }

    @Override
    public void close() {
        try {
            this.data.close();
            if (this.deleteOnExit) {
                ChronicleTools.deleteOnExit((String)this.basePath);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public long lastId() {
        return this.lastId.get();
    }

    @Override
    public long size() {
        return this.size.get();
    }

    @Override
    public boolean hasNext() {
        return this.removeFun.hasNext();
    }

    @Override
    @Nonnull
    public Function<T, Long> offer() {
        return this.offerFun;
    }

    @Override
    @Nonnull
    public Function<Long, T> get() {
        return this.getFun;
    }

    @Override
    @Nonnull
    public Supplier<T> remove() {
        return this.removeFun;
    }

    @Override
    public Iterator<T> iterator() {
        ChronicleRemoveFunction fn;
        try {
            fn = new ChronicleRemoveFunction(this.data.createTailer());
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return fn.hasNext();
            }

            @Override
            public T next() {
                return fn.get();
            }

            @Override
            public void remove() {
                throw new IllegalStateException("This Iterator is read-only.");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T read(ExcerptCommon ex) {
        try {
            int len = ex.readInt();
            ByteBuffer bb = ByteBuffer.allocate(len);
            ex.read(bb);
            bb.flip();
            T t = this.codec.decoder().apply(new Buffer(bb));
            return t;
        }
        finally {
            ex.finish();
        }
    }

    private class ChronicleRemoveFunction
    implements Supplier<T> {
        private final ExcerptTailer ex;

        private ChronicleRemoveFunction(ExcerptTailer ex) throws IOException {
            this.ex = ex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            Object object = IndexedChronicleQueuePersistor.this.monitor;
            synchronized (object) {
                Object obj = IndexedChronicleQueuePersistor.this.read((ExcerptCommon)this.ex);
                IndexedChronicleQueuePersistor.this.size.decrementAndGet();
                return obj;
            }
        }

        public boolean hasNext() {
            return this.ex.nextIndex();
        }
    }

    private class ChronicleGetFunction
    implements Function<Long, T> {
        private final ExcerptTailer ex;

        private ChronicleGetFunction() throws IOException {
            this.ex = IndexedChronicleQueuePersistor.this.data.createTailer();
        }

        @Override
        public T apply(Long id) {
            if (!this.ex.index(id.longValue())) {
                return null;
            }
            return IndexedChronicleQueuePersistor.this.read((ExcerptCommon)this.ex);
        }
    }

    private class ChronicleOfferFunction
    implements Function<T, Long> {
        private final ExcerptAppender ex;

        private ChronicleOfferFunction() throws IOException {
            this.ex = IndexedChronicleQueuePersistor.this.data.createAppender();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long apply(T t) {
            Object object = IndexedChronicleQueuePersistor.this.monitor;
            synchronized (object) {
                Buffer buff = IndexedChronicleQueuePersistor.this.codec.encoder().apply(t);
                int len = buff.remaining();
                this.ex.startExcerpt((long)(4 + len));
                this.ex.writeInt(len);
                this.ex.write(buff.byteBuffer());
                this.ex.finish();
                IndexedChronicleQueuePersistor.this.size.incrementAndGet();
                IndexedChronicleQueuePersistor.this.lastId.set(this.ex.lastWrittenIndex());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Offered {} to Chronicle at index {}, size {}", new Object[]{t, IndexedChronicleQueuePersistor.this.lastId(), IndexedChronicleQueuePersistor.this.size()});
            }
            return IndexedChronicleQueuePersistor.this.lastId();
        }
    }
}

