/*
 * Decompiled with CFR 0.152.
 */
package reactor.filter;

import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.filter.Filter;
import reactor.util.Assert;

public class TraceableDelegatingFilter
implements Filter {
    private final Filter delegate;
    private final Logger log;

    public TraceableDelegatingFilter(Filter delegate) {
        Assert.notNull(delegate, "Delegate Filter cannot be null.");
        this.delegate = delegate;
        this.log = LoggerFactory.getLogger(delegate.getClass());
    }

    @Override
    public <T> List<T> filter(List<T> items, Object key) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("filtering {} using key {}", items, key);
        }
        List<T> l = this.delegate.filter(items, key);
        if (this.log.isTraceEnabled()) {
            this.log.trace("items {} matched key {}", null == items ? Collections.emptyList() : items, key);
        }
        return l;
    }
}

