/*
 * Decompiled with CFR 0.152.
 */
package reactor.event.selector;

import java.util.Map;
import javax.annotation.Nullable;
import reactor.event.selector.HeaderResolver;
import reactor.event.selector.ObjectSelector;
import reactor.event.selector.Selector;
import reactor.event.selector.UriTemplate;

public class UriTemplateSelector
extends ObjectSelector<UriTemplate> {
    private final HeaderResolver headerResolver = new HeaderResolver(){

        @Override
        @Nullable
        public Map<String, String> resolve(Object key) {
            Map<String, String> headers = ((UriTemplate)UriTemplateSelector.this.getObject()).match(key.toString());
            if (null != headers && !headers.isEmpty()) {
                return headers;
            }
            return null;
        }
    };

    public UriTemplateSelector(String tmpl) {
        super(new UriTemplate(tmpl));
    }

    public static Selector uriTemplateSelector(String uriTemplate) {
        return new UriTemplateSelector(uriTemplate);
    }

    @Override
    public boolean matches(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        String path = (String)key;
        return ((UriTemplate)this.getObject()).matches(path);
    }

    @Override
    public HeaderResolver getHeaderResolver() {
        return this.headerResolver;
    }
}

