/*
 * Decompiled with CFR 0.152.
 */
package reactor.event.routing;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.event.Event;
import reactor.event.registry.Registration;
import reactor.event.routing.EventRouter;
import reactor.function.Consumer;
import reactor.util.Assert;

public class TraceableDelegatingEventRouter
implements EventRouter {
    private final EventRouter delegate;
    private final Logger log;

    public TraceableDelegatingEventRouter(EventRouter delegate) {
        Assert.notNull(delegate, "Delegate EventRouter cannot be null.");
        this.delegate = delegate;
        this.log = LoggerFactory.getLogger(delegate.getClass());
    }

    @Override
    public void route(Object key, Event<?> event, List<Registration<? extends Consumer<? extends Event<?>>>> consumers, Consumer<?> completionConsumer, Consumer<Throwable> errorConsumer) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("route({}, {}, {}, {}, {})", new Object[]{key, event, consumers, completionConsumer, errorConsumer});
        }
    }
}

