/*
 * Decompiled with CFR 0.152.
 */
package reactor.event.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.event.registry.Registration;
import reactor.event.registry.Registry;
import reactor.event.selector.Selector;

public class CachingRegistry<T>
implements Registry<T> {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final List<Registration<? extends T>> registrations = new ArrayList<Registration<? extends T>>();
    private final Map<Object, List<Registration<? extends T>>> registrationCache = new HashMap<Object, List<Registration<? extends T>>>();
    private final Logger log = LoggerFactory.getLogger(CachingRegistry.class);
    private final boolean cache;
    private boolean refreshRequired;

    public CachingRegistry() {
        this(true);
    }

    public CachingRegistry(boolean cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V extends T> Registration<V> register(Selector sel, V obj) {
        CachableRegistration reg = new CachableRegistration(sel, obj);
        this.writeLock.lock();
        try {
            this.registrations.add(reg);
            this.refreshRequired = true;
        }
        finally {
            this.writeLock.unlock();
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(Object key) {
        assert (key != null);
        this.writeLock.lock();
        try {
            if (this.registrations.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            List<Registration<T>> regs = this.findMatchingRegistrations(key);
            if (!regs.isEmpty()) {
                this.registrations.removeAll(regs);
                this.refreshRequired = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Registration<? extends T>> select(Object key) {
        List<Registration<Object>> matchingRegistrations;
        block13: {
            this.readLock.lock();
            try {
                if (this.refreshRequired) {
                    this.readLock.unlock();
                    this.writeLock.lock();
                    try {
                        if (this.refreshRequired) {
                            this.registrationCache.clear();
                            this.refreshRequired = false;
                        }
                    }
                    finally {
                        this.readLock.lock();
                        this.writeLock.unlock();
                    }
                }
                if (null != (matchingRegistrations = this.registrationCache.get(key))) break block13;
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    matchingRegistrations = this.registrationCache.get(key);
                    if (null == matchingRegistrations) {
                        matchingRegistrations = this.find(key);
                    }
                }
                finally {
                    this.readLock.lock();
                    this.writeLock.unlock();
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        return matchingRegistrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Registration<? extends T>> iterator() {
        try {
            this.readLock.lock();
            Iterator<Registration<? extends T>> iterator = Collections.unmodifiableList(new ArrayList<Registration<? extends T>>(this.registrations)).iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Registration<? extends T>> find(Object object) {
        this.cacheMiss(object);
        try {
            this.writeLock.lock();
            List<Object> regs = this.registrations.isEmpty() ? Collections.emptyList() : this.findMatchingRegistrations(object);
            if (this.cache) {
                this.registrationCache.put(object, regs);
            }
            List<Registration<? extends T>> list = regs;
            return list;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private List<Registration<? extends T>> findMatchingRegistrations(Object object) {
        ArrayList<Registration<T>> regs = new ArrayList<Registration<T>>();
        for (Registration<T> reg : this.registrations) {
            if (!reg.getSelector().matches(object)) continue;
            regs.add(reg);
        }
        if (regs.isEmpty() && this.log.isTraceEnabled()) {
            this.log.trace("No objects registered for key {}", object);
        }
        return Collections.unmodifiableList(regs);
    }

    protected void cacheMiss(Object key) {
    }

    private class CachableRegistration<V>
    implements Registration<V> {
        private final Selector selector;
        private final V object;
        private volatile boolean cancelAfterUse = false;
        private volatile boolean cancelled = false;
        private volatile boolean paused = false;

        private CachableRegistration(Selector selector, V object) {
            this.selector = selector;
            this.object = object;
        }

        @Override
        public Selector getSelector() {
            return this.selector;
        }

        @Override
        public V getObject() {
            return this.object;
        }

        @Override
        public Registration<V> cancelAfterUse() {
            this.cancelAfterUse = !this.cancelAfterUse;
            return this;
        }

        @Override
        public boolean isCancelAfterUse() {
            return this.cancelAfterUse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Registration<V> cancel() {
            this.cancelled = true;
            CachingRegistry.this.writeLock.lock();
            try {
                CachingRegistry.this.registrations.remove(this);
                CachingRegistry.this.refreshRequired = true;
            }
            finally {
                CachingRegistry.this.writeLock.unlock();
            }
            return this;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public Registration<V> pause() {
            this.paused = true;
            return this;
        }

        @Override
        public boolean isPaused() {
            return this.paused;
        }

        @Override
        public Registration<V> resume() {
            this.paused = false;
            return this;
        }
    }
}

