/*
 * Decompiled with CFR 0.152.
 */
package reactor.event.dispatch;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.event.Event;
import reactor.event.dispatch.BaseDispatcher;
import reactor.event.dispatch.BaseLifecycleDispatcher;
import reactor.function.Supplier;
import reactor.pool.LoadingPool;
import reactor.pool.Pool;
import reactor.queue.BlockingQueueFactory;

public final class BlockingQueueDispatcher
extends BaseLifecycleDispatcher {
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    private final ThreadGroup threadGroup = new ThreadGroup("eventloop");
    private final BlockingQueue<BaseDispatcher.Task> taskQueue = BlockingQueueFactory.createQueue();
    private final Pool<BaseDispatcher.Task> readyTasks;
    private final Thread taskExecutor;

    public BlockingQueueDispatcher(String name, int backlog) {
        this.readyTasks = new LoadingPool<BaseDispatcher.Task>(new Supplier<BaseDispatcher.Task>(){

            @Override
            public BaseDispatcher.Task get() {
                return new BlockingQueueTask();
            }
        }, backlog, 150L);
        String threadName = name + "-dispatcher-" + INSTANCE_COUNT.incrementAndGet();
        this.taskExecutor = new Thread(this.threadGroup, new TaskExecutingRunnable(), threadName);
        this.taskExecutor.setDaemon(true);
        this.taskExecutor.setPriority(5);
        this.taskExecutor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        if (this.taskQueue.isEmpty()) {
            this.shutdown();
            return true;
        }
        BlockingQueue<BaseDispatcher.Task> blockingQueue = this.taskQueue;
        synchronized (blockingQueue) {
            try {
                this.taskQueue.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        this.shutdown();
        return true;
    }

    @Override
    public void shutdown() {
        this.taskExecutor.interrupt();
        super.shutdown();
    }

    @Override
    public void halt() {
        this.taskExecutor.interrupt();
        super.halt();
    }

    @Override
    protected <E extends Event<?>> BaseDispatcher.Task<E> createTask() {
        BaseDispatcher.Task t = this.readyTasks.allocate();
        return null != t ? t : new BlockingQueueTask();
    }

    private class TaskExecutingRunnable
    implements Runnable {
        private TaskExecutingRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BaseDispatcher.Task t = null;
            while (true) {
                try {
                    t = (BaseDispatcher.Task)BlockingQueueDispatcher.this.taskQueue.poll(200L, TimeUnit.MILLISECONDS);
                    if (null == t) continue;
                    t.execute();
                    continue;
                }
                catch (InterruptedException e) {
                    if (null != t) {
                        t.reset();
                        BlockingQueueDispatcher.this.readyTasks.deallocate(t);
                    }
                    if (!BlockingQueueDispatcher.this.taskQueue.isEmpty()) break;
                    BlockingQueue blockingQueue = BlockingQueueDispatcher.this.taskQueue;
                    synchronized (blockingQueue) {
                        BlockingQueueDispatcher.this.taskQueue.notifyAll();
                    }
                }
                catch (Exception e) {
                    Logger log = LoggerFactory.getLogger(BlockingQueueDispatcher.class);
                    if (!log.isErrorEnabled()) continue;
                    log.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                finally {
                    if (null != t) {
                        t.reset();
                        BlockingQueueDispatcher.this.readyTasks.deallocate(t);
                    }
                    if (!BlockingQueueDispatcher.this.taskQueue.isEmpty()) continue;
                    BlockingQueue blockingQueue = BlockingQueueDispatcher.this.taskQueue;
                    synchronized (blockingQueue) {
                        BlockingQueueDispatcher.this.taskQueue.notifyAll();
                    }
                    continue;
                }
                break;
            }
            Thread.currentThread().interrupt();
        }
    }

    private class BlockingQueueTask<E extends Event<?>>
    extends BaseDispatcher.Task<E> {
        private BlockingQueueTask() {
            super(BlockingQueueDispatcher.this);
        }

        @Override
        public void submit() {
            BlockingQueueDispatcher.this.taskQueue.add(this);
        }
    }
}

