/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.support;

import reactor.core.Observable;
import reactor.event.Event;
import reactor.function.Consumer;
import reactor.util.Assert;

public class NotifyConsumer<T>
implements Consumer<T> {
    private final Object notifyKey;
    private final Observable observable;

    public NotifyConsumer(Object notifyKey, Observable observable) {
        Assert.notNull(observable, "Observable cannot be null.");
        this.notifyKey = notifyKey;
        this.observable = observable;
    }

    @Override
    public void accept(T t) {
        Event<T> ev = Event.wrap(t);
        if (null == this.notifyKey) {
            this.observable.notify(ev);
        } else {
            this.observable.notify(this.notifyKey, ev);
        }
    }
}

