/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dynamic.reflect;

import java.lang.reflect.Method;
import reactor.core.dynamic.annotation.Notify;
import reactor.core.dynamic.reflect.MethodNotificationKeyResolver;
import reactor.core.dynamic.reflect.support.AnnotationUtils;
import reactor.core.dynamic.reflect.support.MethodNameUtils;

public final class SimpleMethodNotificationKeyResolver
implements MethodNotificationKeyResolver {
    @Override
    public boolean supports(Method method) {
        return method.getDeclaringClass() != Object.class && !method.getName().contains("$");
    }

    @Override
    public String apply(Method method) {
        Notify notifyAnno = AnnotationUtils.find(method, Notify.class);
        String key = null != notifyAnno ? notifyAnno.value() : MethodNameUtils.methodNameToNotificationKey(method.getName());
        return key;
    }
}

