/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dynamic;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import reactor.convert.Converter;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.core.dynamic.DynamicReactor;
import reactor.core.dynamic.annotation.Dispatcher;
import reactor.core.dynamic.annotation.Notify;
import reactor.core.dynamic.annotation.On;
import reactor.core.dynamic.reflect.MethodNotificationKeyResolver;
import reactor.core.dynamic.reflect.MethodSelectorResolver;
import reactor.core.dynamic.reflect.SimpleMethodNotificationKeyResolver;
import reactor.core.dynamic.reflect.SimpleMethodSelectorResolver;
import reactor.core.spec.ReactorSpec;
import reactor.core.spec.Reactors;
import reactor.event.Event;
import reactor.event.dispatch.SynchronousDispatcher;
import reactor.event.registry.Registration;
import reactor.event.routing.ArgumentConvertingConsumerInvoker;
import reactor.event.routing.ConsumerInvoker;
import reactor.event.selector.Selector;
import reactor.function.Consumer;
import reactor.function.Function;

public class DynamicReactorFactory<T extends DynamicReactor> {
    private final Environment env;
    private final Class<T> type;
    private final List<MethodSelectorResolver> selectorResolvers;
    private final List<MethodNotificationKeyResolver> notificationKeyResolvers;
    private final ConsumerInvoker consumerInvoker;
    private final Converter converter;
    private final Map<Method, DynamicMethod> dynamicMethods = new HashMap<Method, DynamicMethod>();

    public DynamicReactorFactory(Environment env, Class<T> type) {
        this(env, type, Arrays.asList(new SimpleMethodSelectorResolver()), Arrays.asList(new SimpleMethodNotificationKeyResolver()), new ArgumentConvertingConsumerInvoker(null), null);
    }

    public DynamicReactorFactory(Environment env, Class<T> type, List<MethodSelectorResolver> selectorResolvers, List<MethodNotificationKeyResolver> notificationKeyResolvers, ConsumerInvoker consumerInvoker, Converter converter) {
        this.env = env;
        this.type = type;
        this.selectorResolvers = selectorResolvers;
        this.notificationKeyResolvers = notificationKeyResolvers;
        this.consumerInvoker = consumerInvoker;
        this.converter = converter;
    }

    public List<MethodSelectorResolver> getSelectorResolvers() {
        return Collections.unmodifiableList(this.selectorResolvers);
    }

    public ConsumerInvoker getConsumerInvoker() {
        return this.consumerInvoker;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public T create() {
        return (T)((DynamicReactor)Proxy.newProxyInstance(DynamicReactorFactory.class.getClassLoader(), new Class[]{this.type}, new ReactorInvocationHandler(this.type)));
    }

    private static boolean isOn(Method m) {
        return m.getName().startsWith("on") || null != m.getAnnotation(On.class);
    }

    private static boolean isNotify(Method m) {
        return m.getName().startsWith("notify") || null != m.getAnnotation(Notify.class);
    }

    private static <T extends Annotation> T find(Class<?> type, Class<T> annoType) {
        if (type.getDeclaredAnnotations().length > 0) {
            for (Annotation anno : type.getDeclaredAnnotations()) {
                if (!annoType.isAssignableFrom(anno.getClass())) continue;
                return (T)anno;
            }
        }
        return null;
    }

    private static final class DynamicMethod {
        boolean returnsRegistration = false;
        boolean returnsProxy = true;

        private DynamicMethod() {
        }
    }

    private class ReactorInvocationHandler<U>
    implements InvocationHandler {
        private final Map<Method, Selector> selectors = new HashMap<Method, Selector>();
        private final Map<Method, Object> notificationKeys = new HashMap<Method, Object>();
        private final Reactor reactor;

        private ReactorInvocationHandler(Class<U> type) {
            Dispatcher d = (Dispatcher)DynamicReactorFactory.find(type, Dispatcher.class);
            this.reactor = this.createReactor(d);
            block0: for (Method m : type.getDeclaredMethods()) {
                if (m.getDeclaringClass() == Object.class || m.getName().contains("$")) continue;
                DynamicMethod dm = new DynamicMethod();
                dm.returnsRegistration = Registration.class.isAssignableFrom(m.getReturnType());
                dm.returnsProxy = type.isAssignableFrom(m.getReturnType());
                if (DynamicReactorFactory.isOn(m)) {
                    for (MethodSelectorResolver msr : DynamicReactorFactory.this.selectorResolvers) {
                        Selector sel;
                        if (!msr.supports(m) || null == (sel = (Selector)msr.apply(m))) continue;
                        this.selectors.put(m, sel);
                        DynamicReactorFactory.this.dynamicMethods.put(m, dm);
                        continue block0;
                    }
                    continue;
                }
                if (!DynamicReactorFactory.isNotify(m)) continue;
                for (MethodNotificationKeyResolver notificationKeyResolver : DynamicReactorFactory.this.notificationKeyResolvers) {
                    String notificationKey;
                    if (!notificationKeyResolver.supports(m) || null == (notificationKey = (String)notificationKeyResolver.apply(m))) continue;
                    this.notificationKeys.put(m, notificationKey);
                    DynamicReactorFactory.this.dynamicMethods.put(m, dm);
                    continue block0;
                }
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            DynamicMethod dm = (DynamicMethod)DynamicReactorFactory.this.dynamicMethods.get(method);
            if (DynamicReactorFactory.isOn(method)) {
                Selector sel = this.selectors.get(method);
                if (null == sel) {
                    return proxy;
                }
                if (args.length > 1) {
                    throw new IllegalArgumentException("Only pass a single Consumer, Function, Runnable, or Callable");
                }
                final Object arg = args[0];
                Registration reg = null;
                if (Consumer.class.isInstance(arg)) {
                    reg = this.reactor.on(sel, (Consumer)arg);
                } else if (Function.class.isInstance(arg)) {
                    reg = this.reactor.receive(sel, (Function)arg);
                } else if (Runnable.class.isInstance(arg)) {
                    reg = this.reactor.on(sel, new Consumer<Event<?>>(){

                        @Override
                        public void accept(Event<?> event) {
                            ((Runnable)arg).run();
                        }
                    });
                } else if (Callable.class.isInstance(arg)) {
                    reg = this.reactor.receive(sel, new Function<Event<?>, Object>(){

                        @Override
                        public Object apply(Event<?> event) {
                            try {
                                return ((Callable)arg).call();
                            }
                            catch (Exception e) {
                                ReactorInvocationHandler.this.reactor.notify((Object)e.getClass(), Event.wrap(e));
                                return null;
                            }
                        }
                    });
                } else if (null == DynamicReactorFactory.this.converter || !DynamicReactorFactory.this.converter.canConvert(arg.getClass(), Consumer.class)) {
                    throw new IllegalArgumentException(String.format("No Converter available to convert '%s' to Consumer", arg.getClass().getName()));
                }
                return dm.returnsRegistration ? reg : (dm.returnsProxy ? proxy : null);
            }
            if (DynamicReactorFactory.isNotify(method)) {
                Object key = this.notificationKeys.get(method);
                if (null == key) {
                    return proxy;
                }
                if (args.length == 0) {
                    this.reactor.notify(key);
                } else if (args.length == 1) {
                    this.reactor.notify(key, Event.class.isInstance(args[0]) ? (Event<Object>)args[0] : Event.wrap(args[0]));
                }
                return dm.returnsProxy ? proxy : null;
            }
            throw new NoSuchMethodError(method.getName());
        }

        private Reactor createReactor(Dispatcher dispatcherAnnotation) {
            ReactorSpec reactorSpec = (ReactorSpec)Reactors.reactor().env(DynamicReactorFactory.this.env);
            if (dispatcherAnnotation != null) {
                if ("sync".equals(dispatcherAnnotation.value())) {
                    reactorSpec.dispatcher(new SynchronousDispatcher());
                } else {
                    reactorSpec.dispatcher(dispatcherAnnotation.value());
                }
            }
            return (Reactor)reactorSpec.get();
        }
    }
}

