/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.composable.spec;

import java.util.Arrays;
import java.util.Collection;
import reactor.core.Environment;
import reactor.core.composable.Deferred;
import reactor.core.composable.Stream;
import reactor.core.composable.spec.DeferredStreamSpec;
import reactor.event.dispatch.Dispatcher;

public abstract class Streams {
    public static <T> Deferred<T, Stream<T>> defer(Environment env) {
        return Streams.defer(env, env.getDefaultDispatcher());
    }

    public static <T> Deferred<T, Stream<T>> defer(Environment env, String dispatcher) {
        return Streams.defer(env, env.getDispatcher(dispatcher));
    }

    public static <T> Deferred<T, Stream<T>> defer(Environment env, Dispatcher dispatcher) {
        return (Deferred)((DeferredStreamSpec)((DeferredStreamSpec)new DeferredStreamSpec().env(env)).dispatcher(dispatcher)).get();
    }

    public static <T> DeferredStreamSpec<T> defer() {
        return new DeferredStreamSpec();
    }

    public static <T> DeferredStreamSpec<T> defer(T value) {
        return Streams.defer(Arrays.asList(value));
    }

    public static <T> DeferredStreamSpec<T> defer(Iterable<T> values) {
        int batchSize = values instanceof Collection ? ((Collection)values).size() : -1;
        return new DeferredStreamSpec<T>().each(values).batchSize(batchSize);
    }
}

