/*
 * Decompiled with CFR 0.152.
 */
package reactor.core;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import reactor.convert.StandardConverters;
import reactor.core.HashWheelTimer;
import reactor.core.Reactor;
import reactor.core.configuration.ConfigurationReader;
import reactor.core.configuration.DispatcherConfiguration;
import reactor.core.configuration.DispatcherType;
import reactor.core.configuration.PropertiesConfigurationReader;
import reactor.core.configuration.ReactorConfiguration;
import reactor.event.dispatch.BlockingQueueDispatcher;
import reactor.event.dispatch.Dispatcher;
import reactor.event.dispatch.RingBufferDispatcher;
import reactor.event.dispatch.SynchronousDispatcher;
import reactor.event.dispatch.ThreadPoolExecutorDispatcher;
import reactor.filter.Filter;
import reactor.filter.RoundRobinFilter;
import reactor.util.LinkedMultiValueMap;
import reactor.util.MultiValueMap;

public class Environment
implements Iterable<Map.Entry<String, List<Dispatcher>>> {
    public static final String EVENT_LOOP = "eventLoop";
    public static final String RING_BUFFER = "ringBuffer";
    public static final String THREAD_POOL = "threadPoolExecutor";
    public static final int PROCESSORS = Runtime.getRuntime().availableProcessors();
    private static final String DEFAULT_DISPATCHER_NAME = "__default-dispatcher";
    private static final String SYNC_DISPATCHER_NAME = "sync";
    private final Properties env;
    private final HashWheelTimer timer = new HashWheelTimer();
    private final AtomicReference<Reactor> rootReactor = new AtomicReference();
    private final Object monitor = new Object();
    private final Filter dispatcherFilter = new RoundRobinFilter();
    private final MultiValueMap<String, Dispatcher> dispatchers;
    private final String defaultDispatcher;

    public Environment() {
        this(Collections.emptyMap(), new PropertiesConfigurationReader());
    }

    public Environment(ConfigurationReader configurationReader) {
        this(Collections.emptyMap(), configurationReader);
    }

    public Environment(Map<String, List<Dispatcher>> dispatchers, ConfigurationReader configurationReader) {
        this.dispatchers = new LinkedMultiValueMap<String, Dispatcher>(dispatchers);
        ReactorConfiguration configuration = configurationReader.read();
        this.defaultDispatcher = configuration.getDefaultDispatcherName() != null ? configuration.getDefaultDispatcherName() : DEFAULT_DISPATCHER_NAME;
        this.env = configuration.getAdditionalProperties();
        for (DispatcherConfiguration dispatcherConfiguration : configuration.getDispatcherConfigurations()) {
            if (DispatcherType.EVENT_LOOP == dispatcherConfiguration.getType()) {
                int size = this.getSize(dispatcherConfiguration, 0);
                for (int i = 0; i < size; ++i) {
                    this.addDispatcher(dispatcherConfiguration.getName(), this.createBlockingQueueDispatcher(dispatcherConfiguration));
                }
                continue;
            }
            if (DispatcherType.RING_BUFFER == dispatcherConfiguration.getType()) {
                this.addDispatcher(dispatcherConfiguration.getName(), this.createRingBufferDispatcher(dispatcherConfiguration));
                continue;
            }
            if (DispatcherType.SYNCHRONOUS == dispatcherConfiguration.getType()) {
                this.addDispatcher(dispatcherConfiguration.getName(), new SynchronousDispatcher());
                continue;
            }
            if (DispatcherType.THREAD_POOL_EXECUTOR != dispatcherConfiguration.getType()) continue;
            this.addDispatcher(dispatcherConfiguration.getName(), this.createThreadPoolExecutorDispatcher(dispatcherConfiguration));
        }
        this.addDispatcher(SYNC_DISPATCHER_NAME, new SynchronousDispatcher());
    }

    private ThreadPoolExecutorDispatcher createThreadPoolExecutorDispatcher(DispatcherConfiguration dispatcherConfiguration) {
        int size = this.getSize(dispatcherConfiguration, 0);
        int backlog = this.getBacklog(dispatcherConfiguration, 128);
        return new ThreadPoolExecutorDispatcher(size, backlog, dispatcherConfiguration.getName());
    }

    private RingBufferDispatcher createRingBufferDispatcher(DispatcherConfiguration dispatcherConfiguration) {
        int backlog = this.getBacklog(dispatcherConfiguration, 1024);
        return new RingBufferDispatcher(dispatcherConfiguration.getName(), backlog, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
    }

    private BlockingQueueDispatcher createBlockingQueueDispatcher(DispatcherConfiguration dispatcherConfiguration) {
        int backlog = this.getBacklog(dispatcherConfiguration, 128);
        return new BlockingQueueDispatcher(dispatcherConfiguration.getName(), backlog);
    }

    private int getBacklog(DispatcherConfiguration dispatcherConfiguration, int defaultBacklog) {
        Integer backlog = dispatcherConfiguration.getBacklog();
        if (null == backlog) {
            backlog = defaultBacklog;
        }
        return backlog;
    }

    private int getSize(DispatcherConfiguration dispatcherConfiguration, int defaultSize) {
        Integer size = dispatcherConfiguration.getSize();
        if (null == size) {
            size = defaultSize;
        }
        if (size < 1) {
            size = PROCESSORS;
        }
        return size;
    }

    public String getProperty(String key, String defaultValue) {
        return this.env.getProperty(key, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> type, T defaultValue) {
        String val = this.env.getProperty(key);
        if (null == val) {
            return defaultValue;
        }
        if (!type.isAssignableFrom(val.getClass()) && StandardConverters.CONVERTERS.canConvert(String.class, type)) {
            return StandardConverters.CONVERTERS.convert(val, type);
        }
        return (T)val;
    }

    public Dispatcher getDefaultDispatcher() {
        return this.getDispatcher(this.defaultDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dispatcher getDispatcher(String name) {
        Object object = this.monitor;
        synchronized (object) {
            List dispatchers = (List)this.dispatchers.get(name);
            List filteredDispatchers = this.dispatcherFilter.filter(dispatchers, name);
            if (filteredDispatchers.isEmpty()) {
                throw new IllegalArgumentException("No Dispatcher found for name '" + name + "'");
            }
            return (Dispatcher)filteredDispatchers.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Environment addDispatcher(String name, Dispatcher dispatcher) {
        Object object = this.monitor;
        synchronized (object) {
            this.dispatchers.add(name, dispatcher);
            if (name.equals(this.defaultDispatcher)) {
                this.dispatchers.add(DEFAULT_DISPATCHER_NAME, dispatcher);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Environment removeDispatcher(String name) {
        Object object = this.monitor;
        synchronized (object) {
            this.dispatchers.remove(name);
        }
        return this;
    }

    public Reactor getRootReactor() {
        this.rootReactor.compareAndSet(null, new Reactor(this.getDefaultDispatcher()));
        return this.rootReactor.get();
    }

    public HashWheelTimer getRootTimer() {
        return this.timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList dispatchers = new ArrayList();
        Object object = this.monitor;
        synchronized (object) {
            for (Map.Entry entry : this.dispatchers.entrySet()) {
                dispatchers.addAll((Collection)entry.getValue());
            }
        }
        for (Dispatcher dispatcher : dispatchers) {
            dispatcher.shutdown();
        }
        this.timer.cancel();
    }

    @Override
    public Iterator<Map.Entry<String, List<Dispatcher>>> iterator() {
        return this.dispatchers.entrySet().iterator();
    }
}

