/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.yaml.swapper;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.governance.core.yaml.config.metadata.YamlColumnMetaData;
import org.apache.shardingsphere.governance.core.yaml.config.metadata.YamlIndexMetaData;
import org.apache.shardingsphere.governance.core.yaml.config.metadata.YamlLogicSchemaMetaData;
import org.apache.shardingsphere.governance.core.yaml.config.metadata.YamlSchemaMetaData;
import org.apache.shardingsphere.governance.core.yaml.config.metadata.YamlTableMetaData;
import org.apache.shardingsphere.infra.metadata.model.logic.LogicSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.column.PhysicalColumnMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.index.PhysicalIndexMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;
import org.apache.shardingsphere.infra.yaml.swapper.YamlSwapper;

public final class LogicSchemaMetaDataYamlSwapper
implements YamlSwapper<YamlLogicSchemaMetaData, LogicSchemaMetaData> {
    public YamlLogicSchemaMetaData swapToYamlConfiguration(LogicSchemaMetaData metaData) {
        YamlLogicSchemaMetaData result = new YamlLogicSchemaMetaData();
        result.setConfiguredSchemaMetaData(this.convertYamlSchema(metaData.getConfiguredSchemaMetaData()));
        result.setUnconfiguredSchemaMetaDataMap(metaData.getUnconfiguredSchemaMetaDataMap());
        return result;
    }

    public LogicSchemaMetaData swapToObject(YamlLogicSchemaMetaData yamlConfig) {
        PhysicalSchemaMetaData configured = Optional.ofNullable(yamlConfig.getConfiguredSchemaMetaData()).map(this::convertSchema).orElse(new PhysicalSchemaMetaData());
        Map unconfigured = Optional.ofNullable(yamlConfig.getUnconfiguredSchemaMetaDataMap()).orElse(new LinkedHashMap());
        return new LogicSchemaMetaData(configured, unconfigured);
    }

    private PhysicalSchemaMetaData convertSchema(YamlSchemaMetaData schema) {
        return new PhysicalSchemaMetaData((Map)schema.getTables().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.convertTable((YamlTableMetaData)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
    }

    private PhysicalTableMetaData convertTable(YamlTableMetaData table) {
        return new PhysicalTableMetaData(this.convertColumns(table.getColumns()), this.convertIndexes(table.getIndexes()));
    }

    private Collection<PhysicalIndexMetaData> convertIndexes(Map<String, YamlIndexMetaData> indexes) {
        return null == indexes ? Collections.emptyList() : (Collection)indexes.values().stream().map(this::convertIndex).collect(Collectors.toList());
    }

    private PhysicalIndexMetaData convertIndex(YamlIndexMetaData index) {
        return new PhysicalIndexMetaData(index.getName());
    }

    private Collection<PhysicalColumnMetaData> convertColumns(Map<String, YamlColumnMetaData> indexes) {
        return null == indexes ? Collections.emptyList() : (Collection)indexes.values().stream().map(this::convertColumn).collect(Collectors.toList());
    }

    private PhysicalColumnMetaData convertColumn(YamlColumnMetaData column) {
        return new PhysicalColumnMetaData(column.getName(), column.getDataType(), column.getDataTypeName(), column.isPrimaryKey(), column.isGenerated(), column.isCaseSensitive());
    }

    private YamlSchemaMetaData convertYamlSchema(PhysicalSchemaMetaData schema) {
        Map tables = schema.getAllTableNames().stream().collect(Collectors.toMap(each -> each, each -> this.convertYamlTable(schema.get(each)), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        YamlSchemaMetaData result = new YamlSchemaMetaData();
        result.setTables(tables);
        return result;
    }

    private YamlTableMetaData convertYamlTable(PhysicalTableMetaData table) {
        YamlTableMetaData result = new YamlTableMetaData();
        result.setColumns(this.convertYamlColumns(table.getColumns()));
        result.setIndexes(this.convertYamlIndexes(table.getIndexes()));
        return result;
    }

    private Map<String, YamlIndexMetaData> convertYamlIndexes(Map<String, PhysicalIndexMetaData> indexes) {
        return indexes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.convertYamlIndex((PhysicalIndexMetaData)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private YamlIndexMetaData convertYamlIndex(PhysicalIndexMetaData index) {
        YamlIndexMetaData result = new YamlIndexMetaData();
        result.setName(index.getName());
        return result;
    }

    private Map<String, YamlColumnMetaData> convertYamlColumns(Map<String, PhysicalColumnMetaData> columns) {
        return columns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.convertYamlColumn((PhysicalColumnMetaData)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private YamlColumnMetaData convertYamlColumn(PhysicalColumnMetaData column) {
        YamlColumnMetaData result = new YamlColumnMetaData();
        result.setName(column.getName());
        result.setCaseSensitive(column.isCaseSensitive());
        result.setGenerated(column.isGenerated());
        result.setPrimaryKey(column.isPrimaryKey());
        result.setDataType(result.getDataType());
        result.setDataTypeName(result.getDataTypeName());
        return result;
    }
}

