/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.event.listener;

import com.google.common.eventbus.EventBus;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.governance.core.event.GovernanceEventBus;
import org.apache.shardingsphere.governance.core.event.listener.GovernanceListener;
import org.apache.shardingsphere.governance.core.event.model.GovernanceEvent;
import org.apache.shardingsphere.governance.repository.api.GovernanceRepository;
import org.apache.shardingsphere.governance.repository.api.listener.DataChangedEvent;

public abstract class PostGovernanceRepositoryEventListener
implements GovernanceListener {
    private final GovernanceRepository governanceRepository;
    private final Collection<String> watchKeys;

    @Override
    public final void watch(DataChangedEvent.ChangedType ... changedTypes) {
        List<DataChangedEvent.ChangedType> watchedChangedTypeList = Arrays.asList(changedTypes);
        for (String watchKey : this.watchKeys) {
            this.watch(watchKey, watchedChangedTypeList);
        }
    }

    private void watch(String watchKey, Collection<DataChangedEvent.ChangedType> changedTypes) {
        this.governanceRepository.watch(watchKey, dataChangedEvent -> {
            if (changedTypes.contains(dataChangedEvent.getChangedType())) {
                Optional<GovernanceEvent> event = this.createGovernanceEvent(dataChangedEvent);
                event.ifPresent(arg_0 -> ((EventBus)GovernanceEventBus.getInstance()).post(arg_0));
            }
        });
    }

    protected abstract Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent var1);

    @Generated
    public PostGovernanceRepositoryEventListener(GovernanceRepository governanceRepository, Collection<String> watchKeys) {
        this.governanceRepository = governanceRepository;
        this.watchKeys = watchKeys;
    }
}

