/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.registry.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.governance.core.registry.schema.GovernanceSchema;

public final class GovernanceSchemaGroup {
    private final Map<String, Collection<String>> schemaGroup = new HashMap<String, Collection<String>>();

    public void add(GovernanceSchema governanceSchema) {
        String schemaName = governanceSchema.getSchemaName();
        if (!this.schemaGroup.containsKey(schemaName)) {
            this.schemaGroup.put(schemaName, new LinkedList());
        }
        this.schemaGroup.get(schemaName).add(governanceSchema.getDataSourceName());
    }

    public void put(String schemaName, Collection<String> dataSourceNames) {
        this.schemaGroup.put(schemaName, dataSourceNames);
    }

    public Collection<String> getDataSourceNames(String schemaName) {
        return this.schemaGroup.getOrDefault(schemaName, Collections.emptyList());
    }
}

