/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.registry.listener;

import java.util.Collection;
import org.apache.shardingsphere.governance.core.registry.listener.DataSourceStateChangedListener;
import org.apache.shardingsphere.governance.core.registry.listener.InstanceStateChangedListener;
import org.apache.shardingsphere.governance.repository.api.RegistryRepository;
import org.apache.shardingsphere.governance.repository.api.listener.DataChangedEvent;

public final class RegistryListenerManager {
    private final InstanceStateChangedListener instanceStateChangedListener;
    private final DataSourceStateChangedListener dataSourceStateChangedListener;

    public RegistryListenerManager(RegistryRepository registryRepository, Collection<String> schemaNames) {
        this.instanceStateChangedListener = new InstanceStateChangedListener(registryRepository);
        this.dataSourceStateChangedListener = new DataSourceStateChangedListener(registryRepository, schemaNames);
    }

    public void initListeners() {
        this.instanceStateChangedListener.watch(new DataChangedEvent.ChangedType[]{DataChangedEvent.ChangedType.UPDATED});
        this.dataSourceStateChangedListener.watch(new DataChangedEvent.ChangedType[]{DataChangedEvent.ChangedType.UPDATED, DataChangedEvent.ChangedType.DELETED, DataChangedEvent.ChangedType.ADDED});
    }
}

