/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.registry.listener;

import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.governance.core.event.listener.PostGovernanceRepositoryEventListener;
import org.apache.shardingsphere.governance.core.event.model.GovernanceEvent;
import org.apache.shardingsphere.governance.core.registry.RegistryCenterNode;
import org.apache.shardingsphere.governance.core.registry.RegistryCenterNodeStatus;
import org.apache.shardingsphere.governance.core.registry.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.governance.core.registry.schema.GovernanceSchema;
import org.apache.shardingsphere.governance.repository.api.GovernanceRepository;
import org.apache.shardingsphere.governance.repository.api.RegistryRepository;
import org.apache.shardingsphere.governance.repository.api.listener.DataChangedEvent;

public final class DataSourceStateChangedListener
extends PostGovernanceRepositoryEventListener {
    private final RegistryCenterNode registryCenterNode = new RegistryCenterNode();

    public DataSourceStateChangedListener(RegistryRepository registryRepository, Collection<String> schemaNames) {
        super((GovernanceRepository)registryRepository, new RegistryCenterNode().getAllSchemaPaths(schemaNames));
    }

    protected Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        return this.registryCenterNode.getGovernanceSchema(event.getKey()).map(schema -> new DisabledStateChangedEvent((GovernanceSchema)schema, this.isDataSourceDisabled(event)));
    }

    private boolean isDataSourceDisabled(DataChangedEvent event) {
        return RegistryCenterNodeStatus.DISABLED.toString().equalsIgnoreCase(event.getValue()) && (DataChangedEvent.ChangedType.UPDATED == event.getChangedType() || DataChangedEvent.ChangedType.ADDED == event.getChangedType());
    }
}

