/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.registry;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.governance.core.registry.schema.GovernanceSchema;

public final class RegistryCenterNode {
    private static final String ROOT = "states";
    private static final String PROXY_NODES_NAME = "proxynodes";
    private static final String DATA_NODES_NAME = "datanodes";

    public String getProxyNodePath(String instanceId) {
        return Joiner.on((String)"/").join((Object)"", (Object)ROOT, new Object[]{PROXY_NODES_NAME, instanceId});
    }

    public String getDataNodesPath() {
        return Joiner.on((String)"/").join((Object)"", (Object)ROOT, new Object[]{DATA_NODES_NAME});
    }

    public String getSchemaPath(String schemaName) {
        return Joiner.on((String)"/").join((Object)"", (Object)ROOT, new Object[]{DATA_NODES_NAME, schemaName});
    }

    public String getDataSourcePath(String schemaName, String dataSourceName) {
        return Joiner.on((String)"/").join((Object)"", (Object)ROOT, new Object[]{DATA_NODES_NAME, schemaName, dataSourceName});
    }

    public Optional<GovernanceSchema> getGovernanceSchema(String dataSourceNodeFullPath) {
        Pattern pattern = Pattern.compile(this.getDataNodesPath() + "/(\\w+)/(\\w+)$", 2);
        Matcher matcher = pattern.matcher(dataSourceNodeFullPath);
        return matcher.find() ? Optional.of(new GovernanceSchema(matcher.group(1), matcher.group(2))) : Optional.empty();
    }

    public Collection<String> getAllSchemaPaths(Collection<String> schemaNames) {
        ArrayList<String> result = new ArrayList<String>(schemaNames.size());
        for (String schemaName : schemaNames) {
            result.add(this.getSchemaPath(schemaName));
        }
        return result;
    }

    @Generated
    public RegistryCenterNode() {
    }
}

