/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.registry;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.governance.core.registry.RegistryCenterNode;
import org.apache.shardingsphere.governance.core.registry.RegistryCenterNodeStatus;
import org.apache.shardingsphere.governance.core.registry.instance.GovernanceInstance;
import org.apache.shardingsphere.governance.repository.api.RegistryRepository;

public final class RegistryCenter {
    private final RegistryCenterNode node = new RegistryCenterNode();
    private final RegistryRepository repository;
    private final GovernanceInstance instance;

    public RegistryCenter(RegistryRepository registryRepository) {
        this.repository = registryRepository;
        this.instance = GovernanceInstance.getInstance();
    }

    public void persistInstanceOnline() {
        this.repository.persistEphemeral(this.node.getProxyNodePath(this.instance.getInstanceId()), "");
    }

    public void persistDataNodes() {
        this.repository.persist(this.node.getDataNodesPath(), "");
    }

    public void persistInstanceData(String instanceData) {
        this.repository.persist(this.node.getProxyNodePath(this.instance.getInstanceId()), instanceData);
    }

    public String loadInstanceData() {
        return this.repository.get(this.node.getProxyNodePath(this.instance.getInstanceId()));
    }

    public Collection<String> loadDisabledDataSources(String schemaName) {
        return this.loadDataSourcesBySchemaName(schemaName).stream().filter(each -> !Strings.isNullOrEmpty((String)this.getDataSourceNodeData(schemaName, (String)each)) && RegistryCenterNodeStatus.DISABLED.toString().equalsIgnoreCase(this.getDataSourceNodeData(schemaName, (String)each))).collect(Collectors.toList());
    }

    private Collection<String> loadDataSourcesBySchemaName(String schemaName) {
        return this.repository.getChildrenKeys(this.node.getSchemaPath(schemaName));
    }

    private String getDataSourceNodeData(String schemaName, String dataSourceName) {
        return this.repository.get(this.node.getDataSourcePath(schemaName, dataSourceName));
    }
}

