/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.repository.zookeeper;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.shardingsphere.governance.repository.api.ConfigurationRepository;
import org.apache.shardingsphere.governance.repository.api.RegistryRepository;
import org.apache.shardingsphere.governance.repository.api.config.GovernanceCenterConfiguration;
import org.apache.shardingsphere.governance.repository.api.listener.DataChangedEvent;
import org.apache.shardingsphere.governance.repository.api.listener.DataChangedEventListener;
import org.apache.shardingsphere.governance.repository.zookeeper.ZookeeperProperties;
import org.apache.shardingsphere.governance.repository.zookeeper.ZookeeperPropertyKey;
import org.apache.shardingsphere.governance.repository.zookeeper.handler.CuratorZookeeperExceptionHandler;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public final class CuratorZookeeperRepository
implements ConfigurationRepository,
RegistryRepository {
    private final Map<String, CuratorCache> caches = new HashMap<String, CuratorCache>();
    private CuratorFramework client;
    private Properties props = new Properties();

    public void init(String name, GovernanceCenterConfiguration config) {
        ZookeeperProperties zookeeperProperties = new ZookeeperProperties(this.props);
        this.client = this.buildCuratorClient(name, config, zookeeperProperties);
        this.initCuratorClient(zookeeperProperties);
    }

    private CuratorFramework buildCuratorClient(String namespace, GovernanceCenterConfiguration config, ZookeeperProperties zookeeperProperties) {
        int retryIntervalMilliseconds = (Integer)zookeeperProperties.getValue(ZookeeperPropertyKey.RETRY_INTERVAL_MILLISECONDS);
        int maxRetries = (Integer)zookeeperProperties.getValue(ZookeeperPropertyKey.MAX_RETRIES);
        int timeToLiveSeconds = (Integer)zookeeperProperties.getValue(ZookeeperPropertyKey.TIME_TO_LIVE_SECONDS);
        int operationTimeoutMilliseconds = (Integer)zookeeperProperties.getValue(ZookeeperPropertyKey.OPERATION_TIMEOUT_MILLISECONDS);
        String digest = (String)zookeeperProperties.getValue(ZookeeperPropertyKey.DIGEST);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(config.getServerLists()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(retryIntervalMilliseconds, maxRetries, retryIntervalMilliseconds * maxRetries)).namespace(namespace);
        if (0 != timeToLiveSeconds) {
            builder.sessionTimeoutMs(timeToLiveSeconds * 1000);
        }
        if (0 != operationTimeoutMilliseconds) {
            builder.connectionTimeoutMs(operationTimeoutMilliseconds);
        }
        if (!Strings.isNullOrEmpty((String)digest)) {
            builder.authorization(ZookeeperPropertyKey.DIGEST.getKey(), digest.getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        return builder.build();
    }

    private void initCuratorClient(ZookeeperProperties zookeeperProperties) {
        this.client.start();
        try {
            int retryIntervalMilliseconds = (Integer)zookeeperProperties.getValue(ZookeeperPropertyKey.RETRY_INTERVAL_MILLISECONDS);
            int maxRetries = (Integer)zookeeperProperties.getValue(ZookeeperPropertyKey.MAX_RETRIES);
            if (!this.client.blockUntilConnected(retryIntervalMilliseconds * maxRetries, TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new KeeperException.OperationTimeoutException();
            }
        }
        catch (InterruptedException | KeeperException.OperationTimeoutException ex) {
            CuratorZookeeperExceptionHandler.handleException((Exception)ex);
        }
    }

    public String get(String key) {
        CuratorCache cache = this.findTreeCache(key);
        if (null == cache) {
            return this.getDirectly(key);
        }
        Optional resultInCache = cache.get(key);
        if (resultInCache.isPresent()) {
            return null == ((ChildData)resultInCache.get()).getData() ? null : new String(((ChildData)resultInCache.get()).getData(), StandardCharsets.UTF_8);
        }
        return this.getDirectly(key);
    }

    private CuratorCache findTreeCache(String key) {
        return this.caches.entrySet().stream().filter(entry -> key.startsWith((String)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public List<String> getChildrenKeys(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            result.sort(Comparator.reverseOrder());
            return result;
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    public void persist(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
            } else {
                this.update(key, value);
            }
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    private void update(String key, String value) {
        try {
            TransactionOp transactionOp = this.client.transactionOp();
            this.client.transaction().forOperations(new CuratorOp[]{(CuratorOp)transactionOp.check().forPath(key), (CuratorOp)transactionOp.setData().forPath(key, value.getBytes(StandardCharsets.UTF_8))});
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    private String getDirectly(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return null;
        }
    }

    private boolean isExisted(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return false;
        }
    }

    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void delete(String key) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void watch(String key, DataChangedEventListener listener) {
        String path = key + "/";
        if (!this.caches.containsKey(path)) {
            this.addCacheData(key);
        }
        CuratorCache cache = this.caches.get(path);
        cache.listenable().addListener((type, oldData, data) -> {
            String eventPath = CuratorCacheListener.Type.NODE_DELETED == type ? oldData.getPath() : data.getPath();
            byte[] eventDataByte = CuratorCacheListener.Type.NODE_DELETED == type ? oldData.getData() : data.getData();
            DataChangedEvent.ChangedType changedType = this.getChangedType(type);
            if (DataChangedEvent.ChangedType.IGNORED != changedType) {
                listener.onChange(new DataChangedEvent(eventPath, null == eventDataByte ? null : new String(eventDataByte, StandardCharsets.UTF_8), changedType));
            }
        });
    }

    private void addCacheData(String cachePath) {
        CuratorCache cache = CuratorCache.build((CuratorFramework)this.client, (String)cachePath, (CuratorCache.Options[])new CuratorCache.Options[0]);
        try {
            cache.start();
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
        this.caches.put(cachePath + "/", cache);
    }

    private DataChangedEvent.ChangedType getChangedType(CuratorCacheListener.Type type) {
        switch (type) {
            case NODE_CREATED: {
                return DataChangedEvent.ChangedType.ADDED;
            }
            case NODE_CHANGED: {
                return DataChangedEvent.ChangedType.UPDATED;
            }
            case NODE_DELETED: {
                return DataChangedEvent.ChangedType.DELETED;
            }
        }
        return DataChangedEvent.ChangedType.IGNORED;
    }

    public void close() {
        this.caches.values().forEach(CuratorCache::close);
        this.waitForCacheClose();
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    private void waitForCacheClose() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public String getType() {
        return "ZooKeeper";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

