/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.config.listener;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.apache.shardingsphere.governance.core.config.ConfigCenterNode;
import org.apache.shardingsphere.governance.core.event.listener.PostGovernanceRepositoryEventListener;
import org.apache.shardingsphere.governance.core.event.model.GovernanceEvent;
import org.apache.shardingsphere.governance.core.event.model.datasource.DataSourceChangedEvent;
import org.apache.shardingsphere.governance.core.event.model.metadata.MetaDataChangedEvent;
import org.apache.shardingsphere.governance.core.event.model.rule.RuleConfigurationsChangedEvent;
import org.apache.shardingsphere.governance.core.event.model.schema.SchemaAddedEvent;
import org.apache.shardingsphere.governance.core.event.model.schema.SchemaDeletedEvent;
import org.apache.shardingsphere.governance.core.yaml.config.YamlDataSourceConfiguration;
import org.apache.shardingsphere.governance.core.yaml.config.YamlDataSourceConfigurationWrap;
import org.apache.shardingsphere.governance.core.yaml.config.metadata.YamlLogicSchemaMetaData;
import org.apache.shardingsphere.governance.core.yaml.swapper.DataSourceConfigurationYamlSwapper;
import org.apache.shardingsphere.governance.core.yaml.swapper.LogicSchemaMetaDataYamlSwapper;
import org.apache.shardingsphere.governance.repository.api.ConfigurationRepository;
import org.apache.shardingsphere.governance.repository.api.GovernanceRepository;
import org.apache.shardingsphere.governance.repository.api.listener.DataChangedEvent;
import org.apache.shardingsphere.infra.metadata.model.logic.LogicSchemaMetaData;
import org.apache.shardingsphere.infra.yaml.config.YamlRootRuleConfigurations;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.infra.yaml.swapper.YamlRuleConfigurationSwapperEngine;

public final class SchemaChangedListener
extends PostGovernanceRepositoryEventListener {
    private final ConfigCenterNode configurationNode = new ConfigCenterNode();
    private final Collection<String> existedSchemaNames;

    public SchemaChangedListener(ConfigurationRepository configurationRepository, Collection<String> schemaNames) {
        super((GovernanceRepository)configurationRepository, new ConfigCenterNode().getAllSchemaConfigPaths(schemaNames));
        this.existedSchemaNames = new LinkedHashSet<String>(schemaNames);
    }

    protected Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        if (this.configurationNode.getSchemasPath().equals(event.getKey())) {
            return this.createSchemaNamesUpdatedEvent(event.getValue());
        }
        String schemaName = this.configurationNode.getSchemaName(event.getKey());
        if (Strings.isNullOrEmpty((String)schemaName) || !this.isValidNodeChangedEvent(schemaName, event.getKey())) {
            return Optional.empty();
        }
        if (DataChangedEvent.ChangedType.ADDED == event.getChangedType()) {
            return Optional.of(this.createAddedEvent(schemaName));
        }
        if (DataChangedEvent.ChangedType.UPDATED == event.getChangedType()) {
            return Optional.of(this.createUpdatedEvent(schemaName, event));
        }
        if (DataChangedEvent.ChangedType.DELETED == event.getChangedType()) {
            this.existedSchemaNames.remove(schemaName);
            return Optional.of(new SchemaDeletedEvent(schemaName));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> createSchemaNamesUpdatedEvent(String schemaNames) {
        Collection<String> persistedSchemaNames = this.configurationNode.splitSchemaName(schemaNames);
        SetUtils.SetView addedSchemaNames = SetUtils.difference(new HashSet<String>(persistedSchemaNames), new HashSet<String>(this.existedSchemaNames));
        if (!addedSchemaNames.isEmpty()) {
            return Optional.of(this.createAddedEvent((String)addedSchemaNames.iterator().next()));
        }
        SetUtils.SetView deletedSchemaNames = SetUtils.difference(new HashSet<String>(this.existedSchemaNames), new HashSet<String>(persistedSchemaNames));
        if (!deletedSchemaNames.isEmpty()) {
            String schemaName = (String)deletedSchemaNames.iterator().next();
            this.existedSchemaNames.remove(schemaName);
            return Optional.of(new SchemaDeletedEvent(schemaName));
        }
        return Optional.empty();
    }

    private boolean isValidNodeChangedEvent(String schemaName, String nodeFullPath) {
        return !this.existedSchemaNames.contains(schemaName) || this.configurationNode.getDataSourcePath(schemaName).equals(nodeFullPath) || this.configurationNode.getRulePath(schemaName).equals(nodeFullPath) || this.configurationNode.getTablePath(schemaName).equals(nodeFullPath);
    }

    private GovernanceEvent createAddedEvent(String schemaName) {
        this.existedSchemaNames.add(schemaName);
        return new SchemaAddedEvent(schemaName, Collections.emptyMap(), Collections.emptyList());
    }

    private GovernanceEvent createUpdatedEvent(String schemaName, DataChangedEvent event) {
        return this.existedSchemaNames.contains(schemaName) ? this.createUpdatedEventForExistedSchema(schemaName, event) : this.createAddedEvent(schemaName);
    }

    private GovernanceEvent createUpdatedEventForExistedSchema(String schemaName, DataChangedEvent event) {
        if (event.getKey().equals(this.configurationNode.getDataSourcePath(schemaName))) {
            return this.createDataSourceChangedEvent(schemaName, event);
        }
        if (event.getKey().equals(this.configurationNode.getRulePath(schemaName))) {
            return this.createRuleChangedEvent(schemaName, event);
        }
        return this.createMetaDataChangedEvent(schemaName, event);
    }

    private DataSourceChangedEvent createDataSourceChangedEvent(String schemaName, DataChangedEvent event) {
        YamlDataSourceConfigurationWrap result = (YamlDataSourceConfigurationWrap)YamlEngine.unmarshal((String)event.getValue(), YamlDataSourceConfigurationWrap.class);
        Preconditions.checkState((null != result && !result.getDataSources().isEmpty() ? 1 : 0) != 0, (Object)"No available data sources to load for governance.");
        return new DataSourceChangedEvent(schemaName, (Map)result.getDataSources().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new DataSourceConfigurationYamlSwapper().swapToObject((YamlDataSourceConfiguration)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
    }

    private GovernanceEvent createRuleChangedEvent(String schemaName, DataChangedEvent event) {
        YamlRootRuleConfigurations configurations = (YamlRootRuleConfigurations)YamlEngine.unmarshal((String)event.getValue(), YamlRootRuleConfigurations.class);
        Preconditions.checkState((null != configurations ? 1 : 0) != 0, (Object)"No available rule to load for governance.");
        return new RuleConfigurationsChangedEvent(schemaName, new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(configurations.getRules()));
    }

    private GovernanceEvent createMetaDataChangedEvent(String schemaName, DataChangedEvent event) {
        LogicSchemaMetaData logicSchemaMetaData = new LogicSchemaMetaDataYamlSwapper().swapToObject((YamlLogicSchemaMetaData)YamlEngine.unmarshal((String)event.getValue(), YamlLogicSchemaMetaData.class));
        return new MetaDataChangedEvent(schemaName, logicSchemaMetaData);
    }
}

