/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.config.listener;

import java.util.Collection;
import org.apache.shardingsphere.governance.core.config.listener.AuthenticationChangedListener;
import org.apache.shardingsphere.governance.core.config.listener.PropertiesChangedListener;
import org.apache.shardingsphere.governance.core.config.listener.SchemaChangedListener;
import org.apache.shardingsphere.governance.repository.api.ConfigurationRepository;
import org.apache.shardingsphere.governance.repository.api.listener.DataChangedEvent;

public final class ConfigurationListenerManager {
    private final SchemaChangedListener schemaChangedListener;
    private final PropertiesChangedListener propertiesChangedListener;
    private final AuthenticationChangedListener authenticationChangedListener;

    public ConfigurationListenerManager(ConfigurationRepository configurationRepository, Collection<String> schemaNames) {
        this.schemaChangedListener = new SchemaChangedListener(configurationRepository, schemaNames);
        this.propertiesChangedListener = new PropertiesChangedListener(configurationRepository);
        this.authenticationChangedListener = new AuthenticationChangedListener(configurationRepository);
    }

    public void initListeners() {
        this.schemaChangedListener.watch(new DataChangedEvent.ChangedType[]{DataChangedEvent.ChangedType.UPDATED, DataChangedEvent.ChangedType.DELETED, DataChangedEvent.ChangedType.ADDED});
        this.propertiesChangedListener.watch(new DataChangedEvent.ChangedType[]{DataChangedEvent.ChangedType.UPDATED});
        this.authenticationChangedListener.watch(new DataChangedEvent.ChangedType[]{DataChangedEvent.ChangedType.UPDATED});
    }
}

