/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.config;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class ConfigCenterNode {
    private static final String SCHEMAS_NODE = "schemas";
    private static final String DATA_SOURCE_NODE = "datasource";
    private static final String RULE_NODE = "rule";
    private static final String TABLE_NODE = "table";
    private static final String AUTHENTICATION_NODE = "authentication";
    private static final String PROPS_NODE = "props";
    private static final String COMMA_SEPARATOR = ",";
    private static final String PATH_SEPARATOR = "/";

    public String getSchemasPath() {
        return Joiner.on((String)PATH_SEPARATOR).join((Object)"", (Object)SCHEMAS_NODE, new Object[0]);
    }

    public String getSchemaNamePath(String schemaName) {
        return Joiner.on((String)PATH_SEPARATOR).join((Object)"", (Object)SCHEMAS_NODE, new Object[]{schemaName});
    }

    public String getDataSourcePath(String schemaName) {
        return this.getFullPath(schemaName, DATA_SOURCE_NODE);
    }

    public String getRulePath(String schemaName) {
        return this.getFullPath(schemaName, RULE_NODE);
    }

    public String getTablePath(String schemaName) {
        return this.getFullPath(schemaName, TABLE_NODE);
    }

    public String getAuthenticationPath() {
        return this.getFullPath(AUTHENTICATION_NODE);
    }

    public String getPropsPath() {
        return this.getFullPath(PROPS_NODE);
    }

    private String getFullPath(String schemaName, String node) {
        return Joiner.on((String)PATH_SEPARATOR).join((Object)"", (Object)SCHEMAS_NODE, new Object[]{schemaName, node});
    }

    private String getFullPath(String node) {
        return Joiner.on((String)PATH_SEPARATOR).join((Object)"", (Object)node, new Object[0]);
    }

    public String getSchemaName(String configurationNodeFullPath) {
        Pattern pattern = Pattern.compile(this.getSchemasPath() + "/(\\w+)(/datasource|/rule)?", 2);
        Matcher matcher = pattern.matcher(configurationNodeFullPath);
        return matcher.find() ? matcher.group(1) : "";
    }

    public Collection<String> splitSchemaName(String schemaNames) {
        return Strings.isNullOrEmpty((String)schemaNames) ? Collections.emptyList() : Splitter.on((String)COMMA_SEPARATOR).splitToList((CharSequence)schemaNames);
    }

    public Collection<String> getAllSchemaConfigPaths(Collection<String> schemaNames) {
        ArrayList<String> result = new ArrayList<String>(Collections.singletonList(this.getSchemasPath()));
        for (String schemaName : schemaNames) {
            result.add(this.getSchemaNamePath(schemaName));
            result.add(this.getRulePath(schemaName));
            result.add(this.getDataSourcePath(schemaName));
            result.add(this.getTablePath(schemaName));
        }
        return result;
    }

    @Generated
    public ConfigCenterNode() {
    }
}

