/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.config;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.encrypt.algorithm.config.AlgorithmProvidedEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.governance.core.config.ConfigCenterNode;
import org.apache.shardingsphere.governance.core.event.GovernanceEventBus;
import org.apache.shardingsphere.governance.core.event.model.persist.DataSourcePersistEvent;
import org.apache.shardingsphere.governance.core.event.model.persist.MetaDataPersistEvent;
import org.apache.shardingsphere.governance.core.event.model.persist.RulePersistEvent;
import org.apache.shardingsphere.governance.core.event.model.persist.SchemaNamePersistEvent;
import org.apache.shardingsphere.governance.core.yaml.config.YamlDataSourceConfiguration;
import org.apache.shardingsphere.governance.core.yaml.config.YamlDataSourceConfigurationWrap;
import org.apache.shardingsphere.governance.core.yaml.config.metadata.YamlLogicSchemaMetaData;
import org.apache.shardingsphere.governance.core.yaml.swapper.DataSourceConfigurationYamlSwapper;
import org.apache.shardingsphere.governance.core.yaml.swapper.LogicSchemaMetaDataYamlSwapper;
import org.apache.shardingsphere.governance.repository.api.ConfigurationRepository;
import org.apache.shardingsphere.infra.auth.Authentication;
import org.apache.shardingsphere.infra.auth.yaml.config.YamlAuthenticationConfiguration;
import org.apache.shardingsphere.infra.auth.yaml.swapper.AuthenticationYamlSwapper;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.metadata.model.logic.LogicSchemaMetaData;
import org.apache.shardingsphere.infra.yaml.config.YamlRootRuleConfigurations;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.infra.yaml.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.replicaquery.algorithm.config.AlgorithmProvidedReplicaQueryRuleConfiguration;
import org.apache.shardingsphere.replicaquery.api.config.ReplicaQueryRuleConfiguration;
import org.apache.shardingsphere.replicaquery.api.config.rule.ReplicaQueryDataSourceRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.sharding.algorithm.config.AlgorithmProvidedShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;

public final class ConfigCenter {
    private final ConfigCenterNode node = new ConfigCenterNode();
    private final ConfigurationRepository repository;

    public ConfigCenter(ConfigurationRepository repository) {
        this.repository = repository;
        GovernanceEventBus.getInstance().register((Object)this);
    }

    public void persistConfigurations(String schemaName, Map<String, DataSourceConfiguration> dataSourceConfigs, Collection<RuleConfiguration> ruleConfigurations, boolean isOverwrite) {
        this.persistDataSourceConfigurations(schemaName, dataSourceConfigs, isOverwrite);
        this.persistRuleConfigurations(schemaName, ruleConfigurations, isOverwrite);
        this.persistSchemaName(schemaName);
    }

    public void persistGlobalConfiguration(Authentication authentication, Properties props, boolean isOverwrite) {
        this.persistAuthentication(authentication, isOverwrite);
        this.persistProperties(props, isOverwrite);
    }

    @Subscribe
    public synchronized void renew(DataSourcePersistEvent event) {
        this.persistDataSourceConfigurations(event.getSchemaName(), event.getDataSourceConfigurations());
    }

    @Subscribe
    public synchronized void renew(RulePersistEvent event) {
        this.persistRuleConfigurations(event.getSchemaName(), event.getRuleConfigurations());
    }

    @Subscribe
    public synchronized void renew(SchemaNamePersistEvent event) {
        this.persistSchema(event.getSchemaName(), event.isDrop());
    }

    @Subscribe
    public synchronized void renew(MetaDataPersistEvent event) {
        this.persistMetaData(event.getSchemaName(), event.getMetaData());
    }

    private void persistDataSourceConfigurations(String schemaName, Map<String, DataSourceConfiguration> dataSourceConfigurations, boolean isOverwrite) {
        if (!(dataSourceConfigurations.isEmpty() || !isOverwrite && this.hasDataSourceConfiguration(schemaName))) {
            this.persistDataSourceConfigurations(schemaName, dataSourceConfigurations);
        }
    }

    private void persistDataSourceConfigurations(String schemaName, Map<String, DataSourceConfiguration> dataSourceConfigurations) {
        Preconditions.checkState((null != dataSourceConfigurations && !dataSourceConfigurations.isEmpty() ? 1 : 0) != 0, (String)"No available data source in `%s` for governance.", (Object)schemaName);
        Map yamlDataSourceConfigurations = dataSourceConfigurations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new DataSourceConfigurationYamlSwapper().swapToYamlConfiguration((DataSourceConfiguration)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        YamlDataSourceConfigurationWrap yamlDataSourceConfigWrap = new YamlDataSourceConfigurationWrap();
        yamlDataSourceConfigWrap.setDataSources(yamlDataSourceConfigurations);
        this.repository.persist(this.node.getDataSourcePath(schemaName), YamlEngine.marshal((Object)yamlDataSourceConfigWrap));
    }

    private void persistRuleConfigurations(String schemaName, Collection<RuleConfiguration> ruleConfigurations, boolean isOverwrite) {
        if (!(ruleConfigurations.isEmpty() || !isOverwrite && this.hasRuleConfiguration(schemaName))) {
            this.persistRuleConfigurations(schemaName, ruleConfigurations);
        }
    }

    private void persistRuleConfigurations(String schemaName, Collection<RuleConfiguration> ruleConfigurations) {
        LinkedList<RuleConfiguration> configs = new LinkedList<RuleConfiguration>();
        for (RuleConfiguration each : ruleConfigurations) {
            ShardingRuleConfiguration config;
            if (each instanceof ShardingRuleConfiguration) {
                config = (ShardingRuleConfiguration)each;
                Preconditions.checkState((boolean)this.hasAvailableTableConfigurations(config), (String)"No available rule configs in `%s` for governance.", (Object)schemaName);
                configs.add(each);
                continue;
            }
            if (each instanceof AlgorithmProvidedShardingRuleConfiguration) {
                config = (AlgorithmProvidedShardingRuleConfiguration)each;
                Preconditions.checkState((boolean)this.hasAvailableTableConfigurations((AlgorithmProvidedShardingRuleConfiguration)config), (String)"No available rule configs in `%s` for governance.", (Object)schemaName);
                configs.add(each);
                continue;
            }
            if (each instanceof AlgorithmProvidedReplicaQueryRuleConfiguration) {
                config = (AlgorithmProvidedReplicaQueryRuleConfiguration)each;
                this.checkDataSources(schemaName, config.getDataSources());
                configs.add(each);
                continue;
            }
            if (each instanceof AlgorithmProvidedEncryptRuleConfiguration) {
                config = (AlgorithmProvidedEncryptRuleConfiguration)each;
                Preconditions.checkState((!config.getEncryptors().isEmpty() ? 1 : 0) != 0, (String)"No available encrypt rule configuration in `%s` for governance.", (Object)schemaName);
                configs.add(each);
                continue;
            }
            if (each instanceof ReplicaQueryRuleConfiguration) {
                config = (ReplicaQueryRuleConfiguration)each;
                this.checkDataSources(schemaName, config.getDataSources());
                configs.add(each);
                continue;
            }
            if (each instanceof EncryptRuleConfiguration) {
                config = (EncryptRuleConfiguration)each;
                Preconditions.checkState((!config.getEncryptors().isEmpty() ? 1 : 0) != 0, (String)"No available encrypt rule configuration in `%s` for governance.", (Object)schemaName);
                configs.add(each);
                continue;
            }
            if (!(each instanceof ShadowRuleConfiguration)) continue;
            config = (ShadowRuleConfiguration)each;
            boolean isShadow = !config.getColumn().isEmpty() && null != config.getSourceDataSourceNames() && null != config.getShadowDataSourceNames();
            Preconditions.checkState((boolean)isShadow, (String)"No available shadow rule configuration in `%s` for governance.", (Object)schemaName);
            configs.add(each);
        }
        YamlRootRuleConfigurations yamlRuleConfigs = new YamlRootRuleConfigurations();
        yamlRuleConfigs.setRules(new YamlRuleConfigurationSwapperEngine().swapToYamlConfigurations(configs));
        this.repository.persist(this.node.getRulePath(schemaName), YamlEngine.marshal((Object)yamlRuleConfigs));
    }

    private void checkDataSources(String schemaName, Collection<ReplicaQueryDataSourceRuleConfiguration> dataSources) {
        dataSources.forEach(each -> Preconditions.checkState((!each.getPrimaryDataSourceName().isEmpty() ? 1 : 0) != 0, (String)"No available replica-query rule configuration in `%s` for governance.", (Object)schemaName));
    }

    private boolean hasAvailableTableConfigurations(ShardingRuleConfiguration config) {
        return !config.getTables().isEmpty() || null != config.getDefaultTableShardingStrategy() || !config.getAutoTables().isEmpty();
    }

    private boolean hasAvailableTableConfigurations(AlgorithmProvidedShardingRuleConfiguration config) {
        return !config.getTables().isEmpty() || null != config.getDefaultTableShardingStrategy() || !config.getAutoTables().isEmpty();
    }

    private void persistAuthentication(Authentication authentication, boolean isOverwrite) {
        if (null != authentication && (isOverwrite || !this.hasAuthentication())) {
            this.repository.persist(this.node.getAuthenticationPath(), YamlEngine.marshal((Object)new AuthenticationYamlSwapper().swapToYamlConfiguration(authentication)));
        }
    }

    private void persistProperties(Properties props, boolean isOverwrite) {
        if (!(props.isEmpty() || !isOverwrite && this.hasProperties())) {
            this.repository.persist(this.node.getPropsPath(), YamlEngine.marshal((Object)props));
        }
    }

    private boolean hasProperties() {
        return !Strings.isNullOrEmpty((String)this.repository.get(this.node.getPropsPath()));
    }

    private void persistSchemaName(String schemaName) {
        String schemaNames = this.repository.get(this.node.getSchemasPath());
        if (Strings.isNullOrEmpty((String)schemaNames)) {
            this.repository.persist(this.node.getSchemasPath(), schemaName);
            return;
        }
        List schemaNameList = Splitter.on((String)",").splitToList((CharSequence)schemaNames);
        if (schemaNameList.contains(schemaName)) {
            return;
        }
        ArrayList<String> newArrayList = new ArrayList<String>(schemaNameList);
        newArrayList.add(schemaName);
        this.repository.persist(this.node.getSchemasPath(), Joiner.on((String)",").join(newArrayList));
    }

    private void persistSchema(String schemaName, boolean isDrop) {
        LinkedHashSet<String> schemas;
        String schemaNames = this.repository.get(this.node.getSchemasPath());
        LinkedHashSet<String> linkedHashSet = schemas = Strings.isNullOrEmpty((String)schemaNames) ? new LinkedHashSet<String>() : new LinkedHashSet(Splitter.on((String)",").splitToList((CharSequence)schemaNames));
        if (isDrop) {
            schemas.remove(schemaName);
        } else if (!schemas.contains(schemaName)) {
            schemas.add(schemaName);
        }
        this.repository.persist(this.node.getSchemasPath(), Joiner.on((String)",").join(schemas));
    }

    public Map<String, DataSourceConfiguration> loadDataSourceConfigurations(String schemaName) {
        if (!this.hasDataSourceConfiguration(schemaName)) {
            return new LinkedHashMap<String, DataSourceConfiguration>();
        }
        YamlDataSourceConfigurationWrap result = (YamlDataSourceConfigurationWrap)YamlEngine.unmarshal((String)this.repository.get(this.node.getDataSourcePath(schemaName)), YamlDataSourceConfigurationWrap.class);
        return result.getDataSources().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new DataSourceConfigurationYamlSwapper().swapToObject((YamlDataSourceConfiguration)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public Collection<RuleConfiguration> loadRuleConfigurations(String schemaName) {
        return this.hasRuleConfiguration(schemaName) ? new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(((YamlRootRuleConfigurations)YamlEngine.unmarshal((String)this.repository.get(this.node.getRulePath(schemaName)), YamlRootRuleConfigurations.class)).getRules()) : new LinkedList<RuleConfiguration>();
    }

    public Authentication loadAuthentication() {
        return this.hasAuthentication() ? new AuthenticationYamlSwapper().swapToObject((YamlAuthenticationConfiguration)YamlEngine.unmarshal((String)this.repository.get(this.node.getAuthenticationPath()), YamlAuthenticationConfiguration.class)) : new Authentication();
    }

    public Properties loadProperties() {
        return YamlEngine.unmarshalProperties((String)this.repository.get(this.node.getPropsPath()));
    }

    public Collection<String> getAllSchemaNames() {
        String schemaNames = this.repository.get(this.node.getSchemasPath());
        return Strings.isNullOrEmpty((String)schemaNames) ? new LinkedList() : this.node.splitSchemaName(schemaNames);
    }

    public boolean hasRuleConfiguration(String schemaName) {
        return !Strings.isNullOrEmpty((String)this.repository.get(this.node.getRulePath(schemaName)));
    }

    public boolean hasDataSourceConfiguration(String schemaName) {
        return !Strings.isNullOrEmpty((String)this.repository.get(this.node.getDataSourcePath(schemaName)));
    }

    public void persistMetaData(String schemaName, LogicSchemaMetaData logicSchemaMetaData) {
        this.repository.persist(this.node.getTablePath(schemaName), YamlEngine.marshal((Object)new LogicSchemaMetaDataYamlSwapper().swapToYamlConfiguration(logicSchemaMetaData)));
    }

    public Optional<LogicSchemaMetaData> loadMetaData(String schemaName) {
        String path = this.repository.get(this.node.getTablePath(schemaName));
        if (Strings.isNullOrEmpty((String)path)) {
            return Optional.empty();
        }
        return Optional.of(new LogicSchemaMetaDataYamlSwapper().swapToObject((YamlLogicSchemaMetaData)YamlEngine.unmarshal((String)path, YamlLogicSchemaMetaData.class)));
    }

    public void deleteSchema(String schemaName) {
        this.repository.delete(this.node.getSchemaNamePath(schemaName));
    }

    private boolean hasAuthentication() {
        return !Strings.isNullOrEmpty((String)this.repository.get(this.node.getAuthenticationPath()));
    }
}

