/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.facade.repository;

import com.google.common.base.Preconditions;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.governance.repository.api.ConfigurationRepository;
import org.apache.shardingsphere.governance.repository.api.RegistryRepository;
import org.apache.shardingsphere.governance.repository.api.config.GovernanceCenterConfiguration;
import org.apache.shardingsphere.governance.repository.api.config.GovernanceConfiguration;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.typed.TypedSPIRegistry;

public final class GovernanceRepositoryFacade
implements AutoCloseable {
    private final RegistryRepository registryRepository;
    private final ConfigurationRepository configurationRepository;

    public GovernanceRepositoryFacade(GovernanceConfiguration config) {
        this.registryRepository = this.createRegistryRepository(config);
        this.configurationRepository = this.createConfigurationRepository(config);
    }

    private RegistryRepository createRegistryRepository(GovernanceConfiguration config) {
        GovernanceCenterConfiguration registryCenterConfig = config.getRegistryCenterConfiguration();
        Preconditions.checkNotNull((Object)registryCenterConfig, (Object)"Registry center configuration cannot be null.");
        RegistryRepository result = (RegistryRepository)TypedSPIRegistry.getRegisteredService(RegistryRepository.class, (String)registryCenterConfig.getType(), (Properties)registryCenterConfig.getProps());
        result.init(config.getName(), registryCenterConfig);
        return result;
    }

    private ConfigurationRepository createConfigurationRepository(GovernanceConfiguration config) {
        if (config.getAdditionalConfigCenterConfiguration().isPresent()) {
            GovernanceCenterConfiguration additionalConfigCenterConfig = (GovernanceCenterConfiguration)config.getAdditionalConfigCenterConfiguration().get();
            ConfigurationRepository result = (ConfigurationRepository)TypedSPIRegistry.getRegisteredService(ConfigurationRepository.class, (String)additionalConfigCenterConfig.getType(), (Properties)additionalConfigCenterConfig.getProps());
            result.init(config.getName(), additionalConfigCenterConfig);
            return result;
        }
        if (this.registryRepository instanceof ConfigurationRepository) {
            return (ConfigurationRepository)this.registryRepository;
        }
        throw new IllegalArgumentException("Registry repository is not suitable for config center and no additional config center configuration provided.");
    }

    @Override
    public void close() {
        this.registryRepository.close();
        if (this.registryRepository != this.configurationRepository) {
            this.configurationRepository.close();
        }
    }

    @Generated
    public RegistryRepository getRegistryRepository() {
        return this.registryRepository;
    }

    @Generated
    public ConfigurationRepository getConfigurationRepository() {
        return this.configurationRepository;
    }

    static {
        ShardingSphereServiceLoader.register(RegistryRepository.class);
        ShardingSphereServiceLoader.register(ConfigurationRepository.class);
    }
}

