/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.core.facade;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.governance.core.config.ConfigCenter;
import org.apache.shardingsphere.governance.core.facade.listener.GovernanceListenerManager;
import org.apache.shardingsphere.governance.core.facade.repository.GovernanceRepositoryFacade;
import org.apache.shardingsphere.governance.core.registry.RegistryCenter;
import org.apache.shardingsphere.governance.repository.api.config.GovernanceConfiguration;
import org.apache.shardingsphere.infra.auth.Authentication;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;

public final class GovernanceFacade
implements AutoCloseable {
    private boolean isOverwrite;
    private GovernanceRepositoryFacade repositoryFacade;
    private ConfigCenter configCenter;
    private RegistryCenter registryCenter;
    private GovernanceListenerManager listenerManager;

    public void init(GovernanceConfiguration config, Collection<String> schemaNames) {
        this.isOverwrite = config.isOverwrite();
        this.repositoryFacade = new GovernanceRepositoryFacade(config);
        this.registryCenter = new RegistryCenter(this.repositoryFacade.getRegistryRepository());
        this.configCenter = new ConfigCenter(this.repositoryFacade.getConfigurationRepository());
        this.listenerManager = new GovernanceListenerManager(this.repositoryFacade.getRegistryRepository(), this.repositoryFacade.getConfigurationRepository(), schemaNames.isEmpty() ? this.configCenter.getAllSchemaNames() : schemaNames);
    }

    public void onlineInstance(Map<String, Map<String, DataSourceConfiguration>> dataSourceConfigMap, Map<String, Collection<RuleConfiguration>> schemaRuleMap, Authentication authentication, Properties props) {
        this.configCenter.persistGlobalConfiguration(authentication, props, this.isOverwrite);
        for (Map.Entry<String, Map<String, DataSourceConfiguration>> entry : dataSourceConfigMap.entrySet()) {
            this.configCenter.persistConfigurations(entry.getKey(), dataSourceConfigMap.get(entry.getKey()), schemaRuleMap.get(entry.getKey()), this.isOverwrite);
        }
        this.onlineInstance();
    }

    public void onlineInstance() {
        this.registryCenter.persistInstanceOnline();
        this.registryCenter.persistDataNodes();
        this.listenerManager.init();
    }

    @Override
    public void close() {
        this.repositoryFacade.close();
    }

    @Generated
    public ConfigCenter getConfigCenter() {
        return this.configCenter;
    }

    @Generated
    public RegistryCenter getRegistryCenter() {
        return this.registryCenter;
    }
}

