/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.web.controller;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shardingsphere.ui.common.dto.ShardingSphereSchemaDTO;
import org.apache.shardingsphere.ui.servcie.ShardingSchemaService;
import org.apache.shardingsphere.ui.web.response.ResponseResult;
import org.apache.shardingsphere.ui.web.response.ResponseResultUtil;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/schema"})
public final class ShardingSchemaController {
    @Resource
    private ShardingSchemaService shardingSchemaService;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ResponseResult<Collection<String>> loadAllSchemaNames() {
        return ResponseResultUtil.build(this.shardingSchemaService.getAllSchemaNames());
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseResult addSchema(@RequestBody ShardingSphereSchemaDTO schemaDTO) {
        this.shardingSchemaService.addSchemaConfiguration(schemaDTO.getName(), schemaDTO.getRuleConfiguration(), schemaDTO.getDataSourceConfiguration());
        return ResponseResultUtil.success();
    }

    @RequestMapping(value={"/{schemaName}"}, method={RequestMethod.DELETE})
    public ResponseResult deleteSchema(@PathVariable(value="schemaName") String schemaName) {
        this.shardingSchemaService.deleteSchemaConfiguration(schemaName);
        return ResponseResultUtil.success();
    }

    @RequestMapping(value={"/rule/{schemaName}"}, method={RequestMethod.GET})
    public ResponseResult<String> loadRuleConfiguration(@PathVariable(value="schemaName") String schemaName) {
        return ResponseResultUtil.build(this.shardingSchemaService.getRuleConfiguration(schemaName));
    }

    @RequestMapping(value={"/rule/{schemaName}"}, method={RequestMethod.PUT})
    public ResponseResult updateRuleConfiguration(@PathVariable(value="schemaName") String schemaName, @RequestBody Map<String, String> configMap) {
        this.shardingSchemaService.updateRuleConfiguration(schemaName, configMap.get("ruleConfig"));
        return ResponseResultUtil.success();
    }

    @RequestMapping(value={"/datasource/{schemaName}"}, method={RequestMethod.GET})
    public ResponseResult<String> loadDataSourceConfiguration(@PathVariable(value="schemaName") String schemaName) {
        return ResponseResultUtil.build(this.shardingSchemaService.getDataSourceConfiguration(schemaName));
    }

    @RequestMapping(value={"/datasource/{schemaName}"}, method={RequestMethod.PUT})
    public ResponseResult updateDataSourceConfiguration(@PathVariable(value="schemaName") String schemaName, @RequestBody Map<String, String> configMap) {
        this.shardingSchemaService.updateDataSourceConfiguration(schemaName, configMap.get("dataSourceConfig"));
        return ResponseResultUtil.success();
    }

    @RequestMapping(value={"/metadata/{schemaName}"}, method={RequestMethod.GET})
    public ResponseResult<String> loadMetadataConfiguration(@PathVariable(value="schemaName") String schemaName) {
        return ResponseResultUtil.build(this.shardingSchemaService.getMetadataConfiguration(schemaName));
    }
}

