/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.web.controller;

import java.util.List;
import org.apache.shardingsphere.ui.common.domain.CenterConfig;
import org.apache.shardingsphere.ui.common.dto.CenterConfigDTO;
import org.apache.shardingsphere.ui.servcie.CenterConfigService;
import org.apache.shardingsphere.ui.util.CenterRepositoryFactory;
import org.apache.shardingsphere.ui.web.response.ResponseResult;
import org.apache.shardingsphere.ui.web.response.ResponseResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/reg-center"})
public final class RegistryCenterController {
    @Autowired
    private CenterConfigService centerConfigService;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ResponseResult<List<CenterConfig>> loadConfigs() {
        return ResponseResultUtil.build(this.centerConfigService.loadAll().getCenterConfigs());
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseResult add(@RequestBody CenterConfig config) {
        this.centerConfigService.add(config);
        return ResponseResultUtil.success();
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    public ResponseResult delete(@RequestBody CenterConfig config) {
        this.centerConfigService.delete(config.getName());
        return ResponseResultUtil.success();
    }

    @RequestMapping(value={"/connect"}, method={RequestMethod.POST})
    public ResponseResult<Boolean> connect(@RequestBody CenterConfig config) {
        CenterRepositoryFactory.createRegistryRepository(this.centerConfigService.load(config.getName()));
        this.centerConfigService.setActivated(config.getName());
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @RequestMapping(value={"/activated"}, method={RequestMethod.GET})
    public ResponseResult<CenterConfig> activated() {
        return ResponseResultUtil.build(this.centerConfigService.loadActivated().orElse(null));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseResult update(@RequestBody CenterConfigDTO config) {
        this.centerConfigService.update(config);
        return ResponseResultUtil.success();
    }
}

