/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.web.controller;

import java.util.Collection;
import org.apache.shardingsphere.ui.common.dto.InstanceDTO;
import org.apache.shardingsphere.ui.common.dto.ReplicaDataSourceDTO;
import org.apache.shardingsphere.ui.servcie.GovernanceService;
import org.apache.shardingsphere.ui.web.response.ResponseResult;
import org.apache.shardingsphere.ui.web.response.ResponseResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/governance"})
public final class GovernanceController {
    @Autowired
    private GovernanceService governanceService;

    @RequestMapping(value={"/instance"}, method={RequestMethod.GET})
    public ResponseResult<Collection<InstanceDTO>> loadAllInstances() {
        return ResponseResultUtil.build(this.governanceService.getALLInstance());
    }

    @RequestMapping(value={"/instance"}, method={RequestMethod.PUT})
    public ResponseResult updateInstanceStatus(@RequestBody InstanceDTO instanceDTO) {
        this.governanceService.updateInstanceStatus(instanceDTO.getInstanceId(), instanceDTO.isEnabled());
        return ResponseResultUtil.success();
    }

    @RequestMapping(value={"/datasource"}, method={RequestMethod.GET})
    public ResponseResult<Collection<ReplicaDataSourceDTO>> loadAllReplicaDataSources() {
        return ResponseResultUtil.build(this.governanceService.getAllReplicaDataSource());
    }

    @RequestMapping(value={"/datasource"}, method={RequestMethod.PUT})
    public ResponseResult updateReplicaDataSourceStatus(@RequestBody ReplicaDataSourceDTO replicaDataSourceDTO) {
        this.governanceService.updateReplicaDataSourceStatus(replicaDataSourceDTO.getSchema(), replicaDataSourceDTO.getReplicaDataSourceName(), replicaDataSourceDTO.isEnabled());
        return ResponseResultUtil.success();
    }
}

